---
id: 68caacb0f4311cc9be9a2132
title: Step 32
challengeType: 20
dashedName: step-32
---

# --description--

Now you'll focus on coding a `salary` setter. After the `salary` getter, create a simple setter for the `salary` property that sets `self._salary` to the value passed to the method as its argument. After that, print `Salary updated to $` followed by the new salary and a period.

You'll take care of validating the new salary in the next few steps.

# --hints--

Your `Employee` class should have a `salary` method decorated with `@salary.setter`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Employee").find_functions("salary")[1].has_decorators("salary.setter")`)) })
```

Your `salary` setter should set `self._salary` to the value passed to it as the argument.

```js
({ test: () => runPython(`
  emp = Employee('Frank', 'trainee')
  built_in_print = print
  print = lambda x: x
  emp.salary += 100
  print = built_in_print
  assert emp.salary == Employee._base_salaries['trainee'] + 100
`) })
```

Your `salary` setter should print `Salary updated to $` followed by the new salary and a period.

```js
({ test: () => runPython(`
    import io
    import sys
        
    captured_output = io.StringIO()
    sys.stdout = captured_output
        
    emp = Employee('Frank', 'trainee')
    emp.salary += 100
        
    sys.stdout = sys.__stdout__
    output = captured_output.getvalue()
        
    assert f"Salary updated to \${Employee._base_salaries['trainee'] + 100}" in output
`) })
```

# --seed--

## --seed-contents--

```py
class Employee:
    _base_salaries = {
        'trainee': 1000,
        'junior': 2000,
        'mid-level': 3000,
        'senior': 4000,
    }

    def __init__(self, name, level):
        if not (isinstance(name, str) and isinstance(level, str)):
            raise TypeError("'name' and 'level' attribute must be of type 'str'.")
        if level not in Employee._base_salaries:
            raise ValueError(f"Invalid value '{level}' for 'level' attribute.")
        self._name = name
        self._level = level
        self._salary = Employee._base_salaries[level]

    def __str__(self):
        return f'{self.name}: {self.level}'

    def __repr__(self):
        return f"Employee('{self.name}', '{self.level}')"

    @property
    def name(self):
        return self._name

    @name.setter
    def name(self, new_name):
        if not isinstance(new_name, str):
            raise TypeError("'name' must be a string.")
        self._name = new_name
        print(f"'name' updated to '{self.name}'.")

    @property
    def level(self):
        return self._level

    @level.setter
    def level(self, new_level):
        if new_level not in Employee._base_salaries:
            raise ValueError(f"Invalid value '{new_level}' for 'level' attribute.")
        if new_level == self.level:
            raise ValueError(f"'{self.level}' is already the selected level.")
        if Employee._base_salaries[new_level] < Employee._base_salaries[self.level]:
            raise ValueError(f"Cannot change to lower level.")
        print(f"'{self.name}' promoted to '{new_level}'.")
        self._salary = Employee._base_salaries[new_level]
        self._level = new_level
--fcc-editable-region--
    @property
    def salary(self):
        return self._salary

    
--fcc-editable-region--

charlie_brown = Employee('Charlie Brown', 'trainee')
print(charlie_brown)
print(f'Base salary: ${charlie_brown.salary}')

charlie_brown.level = 'junior'

```
