---
id: 68ca758f8160b11757f877ae
title: Step 28
challengeType: 20
dashedName: step-28
---

# --description--

Finally, create a third `if` statement that raises a `ValueError` with the message `Cannot change to lower level.` when the base salary of the new level is less than the base salary of the current level.

# --hints--

You should have a third `if` statement inside your `level` setter.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Employee").find_functions("level")[1].find_ifs()[2]`)) })
```

When `new_level` is lower than `self.level`, you should raise a `ValueError` with the message `Cannot change to lower level.`.

```js
({ test: () => runPython(`
  emp = Employee('Frank', 'junior')
  try:
    emp.level = "trainee"
  except ValueError as e:
    assert str(e) == "Cannot change to lower level."
  else:
      assert False, "Expected to raise ValueError with invalid new_level"
`) })
```

You should not raise any exception when `new_level` is higher than `self.level`.

```js
({ test: () => runPython(`
  emp = Employee('Frank', 'junior')
  try:
    emp.level = "senior"
  except Exception:
    assert False, "Expected not to raise exception with valid new_level"
`) })
```

# --seed--

## --seed-contents--

```py
class Employee:
    _base_salaries = {
        'trainee': 1000,
        'junior': 2000,
        'mid-level': 3000,
        'senior': 4000,
    }

    def __init__(self, name, level):
        if not (isinstance(name, str) and isinstance(level, str)):
            raise TypeError("'name' and 'level' attribute must be of type 'str'.")
        if level not in Employee._base_salaries:
            raise ValueError(f"Invalid value '{level}' for 'level' attribute.")
        self._name = name
        self._level = level
        self._salary = Employee._base_salaries[level]

    def __str__(self):
        return f'{self.name}: {self.level}'

    def __repr__(self):
        return f"Employee('{self.name}', '{self.level}')"

    @property
    def name(self):
        return self._name

    @name.setter
    def name(self, new_name):
        if not isinstance(new_name, str):
            raise TypeError("'name' must be a string.")
        self._name = new_name
        print(f"'name' updated to '{self.name}'.")

    @property
    def level(self):
        return self._level
--fcc-editable-region--
    @level.setter
    def level(self, new_level):
        if new_level not in Employee._base_salaries:
            raise ValueError(f"Invalid value '{new_level}' for 'level' attribute.")
        if new_level == self.level:
            raise ValueError(f"'{self.level}' is already the selected level.")
        
        self._level = new_level
    
--fcc-editable-region--
    @property
    def salary(self):
        return self._salary

charlie_brown = Employee('Charlie Brown', 'trainee')
print(charlie_brown)
print(f'Base salary: ${charlie_brown.salary}')
```
