---
id: 68c9cab4b1118da59eecfc56
title: Step 27
challengeType: 20
dashedName: step-27
---

# --description--

After the existing `if` statement, create another one to raise a `ValueError` when `new_level` is already the selected level.

For the message, use `'{level}' is already the selected level.`, where `{level}` should be replaced by the current level.

# --hints--

You should have a second `if` statement inside your `level` setter.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Employee").find_functions("level")[1].find_ifs()[1]`)) })
```

When `new_level` is equal to `self.level`, you should raise a `ValueError` with the message `'{level}' is already the selected level.`, where `{level}` should be replaced by the current level.

```js
({ test: () => runPython(`
  emp = Employee('Frank', 'trainee')
  try:
    emp.level = "trainee"
  except ValueError as e:
    assert str(e) == "'trainee' is already the selected level."
  else:
      assert False, "Expected to raise ValueError with invalid new_level"
`) })
```

# --seed--

## --seed-contents--

```py
class Employee:
    _base_salaries = {
        'trainee': 1000,
        'junior': 2000,
        'mid-level': 3000,
        'senior': 4000,
    }

    def __init__(self, name, level):
        if not (isinstance(name, str) and isinstance(level, str)):
            raise TypeError("'name' and 'level' attribute must be of type 'str'.")
        if level not in Employee._base_salaries:
            raise ValueError(f"Invalid value '{level}' for 'level' attribute.")
        self._name = name
        self._level = level
        self._salary = Employee._base_salaries[level]

    def __str__(self):
        return f'{self.name}: {self.level}'

    def __repr__(self):
        return f"Employee('{self.name}', '{self.level}')"

    @property
    def name(self):
        return self._name

    @name.setter
    def name(self, new_name):
        if not isinstance(new_name, str):
            raise TypeError("'name' must be a string.")
        self._name = new_name
        print(f"'name' updated to '{self.name}'.")

    @property
    def level(self):
        return self._level
--fcc-editable-region--
    @level.setter
    def level(self, new_level):
        if new_level not in Employee._base_salaries:
            raise ValueError(f"Invalid value '{new_level}' for 'level' attribute.")
        
        
        self._level = new_level
    
--fcc-editable-region--
    @property
    def salary(self):
        return self._salary

charlie_brown = Employee('Charlie Brown', 'trainee')
print(charlie_brown)
print(f'Base salary: ${charlie_brown.salary}')
```
