---
id: 68c7f7012a700243eff1cbc0
title: Step 16
challengeType: 20
dashedName: step-16
---

# --description--

The level used to instantiate an employee should be chosen among specific levels. You'll use `_base_salaries` to validate the level and set the right salary for the employee.

After your existing `if` statement, create another `if` that checks if `level` is not in `Employee._base_salaries`.

Inside the new `if` statement, raise a `ValueError` with the message `Invalid value '{level}' for 'level' attribute.`, where `{level}` should be replaced by the value of the `level` argument.

# --hints--

When `level` is not in `Employee._base_salaries`, you should raise a `ValueError` with the message `Invalid value '{level}' for 'level' attribute.`, where `{level}` should be replaced by the value of the `level` argument.

```js
({ test: () => runPython(`
  try:
    Employee("Frank", "dreamer")
  except ValueError as e:
    assert str(e) == "Invalid value 'dreamer' for 'level' attribute."
  else:
    assert False, "Expected to raise ValueError with invalid level"
`) })
```

You should not raise any exception when `level` is in `Employee._base_salaries`.

```js
({ test: () => runPython(`
  levels = [
    "trainee",
    "junior",
    "mid-level",
    "senior"
  ]
  for level in levels:
    try:
      Employee("Frank", level)
    except Exception:
      assert False, f"Expected not to raise ValueError with level '{level}'"
    
`) })
```

# --seed--

## --seed-contents--

```py
class Employee:
    _base_salaries = {
        'trainee': 1000,
        'junior': 2000,
        'mid-level': 3000,
        'senior': 4000,
    }
--fcc-editable-region--
    def __init__(self, name, level):
        if not (isinstance(name, str) and isinstance(level, str)):
            raise TypeError("'name' and 'level' attribute must be of type 'str'.")
        
        self._name = name
        self._level = level
--fcc-editable-region--
    def __str__(self):
        return f'{self.name}: {self.level}'

    def __repr__(self):
        return f"Employee('{self.name}', '{self.level}')"

    @property
    def name(self):
        return self._name

    @property
    def level(self):
        return self._level

charlie_brown = Employee('Charlie Brown', 'trainee')
print(charlie_brown)
```
