---
id: 68779156bd3704b727ba5f38
title: Step 10
challengeType: 0
dashedName: step-10
---

# --description--

As you recall from earlier lessons, you can use the `map` method to iterate through the different objects and render the components dynamically like this:

```jsx
export function App() {
  const fruits = [
    {
      id: 1,
      name: "Apple",
      color: "Red"
    },
    {
      id: 2,
      name: "Banana",
      color: "Yellow"
    },
    {
      id: 3,
      name: "Grapes",
      color: "Purple"
    }
  ];
  return (
    <div>
      {fruits.map(fruit => (
        <Card
          key={fruit.id}
          name={fruit.name}
          color={fruit.color}
        />
      ))}
    </div>
  );
}
```

Use the `map()` method to render a single `Card` from the array. Pass the `name`, `title`, and `bio` as props to the `Card` component.

# --hints--

You should use the `map()` method to iterate through the `profiles` array.

```js
assert.match(code, /profiles\.map\s*\(/);
```

You should pass `name`, `title`, and `bio` props from the `profile` object.

```js
const testElem = await __helpers.prepTestComponent(window.index.App);
const cards = testElem.querySelectorAll(".card");
assert.lengthOf(cards, 1);

assert.equal(cards[0]?.querySelector("h2").textContent, "Mark");
assert.equal(cards[0]?.querySelector(".card-title").textContent, "Frontend developer");
assert.equal(cards[0]?.querySelector("p:last-of-type").textContent, "I like to work with different frontend technologies and play video games.");
```

# --seed--

## --seed-contents--

```html
<!doctype html>
<html>
  <head>
    <meta charset="UTF-8" />
    <title>Reusable Card component</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.3/babel.min.js"></script>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      src="index.jsx"
    ></script>
     <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <div id="root"></div>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      data-presets="react"
      data-type="module"
    >
      import { App } from './index.jsx';
      ReactDOM.createRoot(document.getElementById('root')).render(
        <App />
      );
    </script>
  </body>
</html>
```

```css
:root {
  --dark-grey: #1b1b32;
  --light-grey: #f5f6f7;
  --dark-orange: #f89808;
}

body {
  background-color: var(--dark-grey);
}

.flex-container {
  display: flex;
  flex-wrap: wrap;
  justify-content: space-around;
  align-items: center;
}

.card {
  border: 5px solid var(--dark-orange);
  border-radius: 10px;
  width: 100%;
  padding: 20px;
  margin: 10px 0;
  background-color: var(--light-grey);
}

.card-title {
  border-bottom: 4px solid var(--dark-orange);
  width: fit-content;
}

@media (min-width: 768px) {
  .card {
    width: 300px;
  }
}
```

```jsx
export function Card({ name, title, bio }) {
  return (
    <div className="card">
      <h2>{name}</h2>
      <p className="card-title">{title}</p>
      <p>{bio}</p>
    </div>
  )
}

export function App() {
  const profiles = [
    {
      id: 1,
      name: "Mark",
      title: "Frontend developer",
      bio: "I like to work with different frontend technologies and play video games."
    }
  ];
  return (
    <div className="flex-container">
      --fcc-editable-region--
     
      --fcc-editable-region--
    </div>
  );
}
```
