---
id: 67457ff2dc531fbed928a0f0
title: Step 2
challengeType: 0
dashedName: step-2
---

# --description--

Now it is time to build out the `Navbar` component using JSX.

You learned in previous lessons that JSX is a syntax extension for JavaScript that allows you to write HTML-like code within JavaScript, making it easier to create and manage React components.

Here is a reminder of what JSX looks like:

```jsx
const App = () => {
  return (
    <div>
      <h1>freeCodeCamp React Curriculum</h1>
      <p>I love learning with freeCodeCamp!</p>
    </div>
  );
}
```


Inside the `Navbar` component, return a `nav` element that has a `className` of `navbar`.

The reason why `className` is used here instead of `class` is because `class` is a reserved keyword in JavaScript. So, React uses `className` as a way to apply classes to elements.

# --hints--

You should return a `nav` element.

```js
assert.exists(document.querySelector('nav'));
```

Your `nav` element should have a `className` attribute with the value `navbar`.

```js
assert.equal(document.querySelector('nav')?.getAttribute('class'), 'navbar');
```

# --seed--

## --seed-contents--

```html
<!doctype html>
<html>
  <head>
    <meta charset="UTF-8" />
    <title>Reusable Navbar</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.3/babel.min.js"></script>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      src="index.jsx"
    ></script>
     <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <div id="root"></div>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      data-presets="react"
      data-type="module"
    >
      import { Navbar } from './index.jsx';
      ReactDOM.createRoot(document.getElementById('root')).render(
        <Navbar />
      );
    </script>
  </body>
</html>
```

```css
*,
*::before,
*::after {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
}

:root {
  --white: #fff;
  --light-grey: #e1e0e0;
  --dark-purple: #7c0e7c;
  --black: #000;
}

body {
  background-color: var(--light-grey);
}

.navbar {
  background-color: var(--white);
}

.navbar ul {
  display: flex;
  justify-content: space-around;
}

.navbar ul li {
  list-style: none;
  border-radius: 4px;
}

.navbar ul li a {
  text-decoration: none;
  color: var(--black);
  padding: 10px;
  display: inline-block;
  width: 100%;
}

button {
  background: transparent;
  border: none;
  font-family: 'Times New Roman', Times, serif;
  padding: 10px;
  font-size: 1rem;
}

.navbar ul .nav-item a:hover {
  background-color: var(--dark-purple);
  color: var(--white);
}

button:hover {
  background-color: var(--dark-purple);
  color: var(--white);
}

.navbar ul .nav-item .sub-menu {
  visibility: hidden;
  opacity: 0;
  position: absolute;
  right: 5%;
  transition: opacity 0.5s ease;
  display: block;
  background-color: var(--white);
}

@media (min-width: 768px) {
  .navbar ul .nav-item .sub-menu {
    right: 15%;
  }
}

@media (min-width: 1024px) {
  .navbar ul .nav-item .sub-menu {
    right: 13%;
  }
}

.navbar ul .nav-item:hover .sub-menu,
.navbar ul .nav-item:focus-within .sub-menu {
  visibility: visible;
  opacity: 1;
}
```

```jsx
--fcc-editable-region--
export const Navbar = () => {
  
}
--fcc-editable-region--
```
