---
id: 6737a95d5b431860f96ca7bb
title: Step 27
challengeType: 1
dashedName: step-27
---

# --description--

Now try to add the `ballerina` object to your `catalogSet` inside your function a second time. You'll see that nothing happens, because the object is already stored in your set and duplicate elements are not allowed in sets.

If you want, you can check the number of elements in your set by using the `size` property, in the same way you did before for your map.

# --hints--

You should `add` the `ballerina` object a second time to your set within the `displayPlantsSet` function.

```js
const testArr = [];
const temp = Set.prototype.add;
try {
    Set.prototype.add = obj => {testArr.push(obj)};
    displayPlantsSet()
    assert.lengthOf(testArr, 2);
    assert.strictEqual(testArr[0], ballerina);
    assert.strictEqual(testArr[1], ballerina);
} finally {
    Set.prototype.add = temp;
}
```

# --seed--

## --seed-contents--

```js
const ballerina = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Ballerina"
}

const prettyPolly = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Pretty Polly"
}

const willowVale = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Willow Vale"
}

const hidcote = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Hidcote"
}

const imperialGem = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Imperial Gem"
}

const royalCrown = {
    commonName: "French lavender",
    scientificName: "Lavandula dentata",
    cultivar: "Royal Crown"
}

const catalog = new Map();
catalog.set(ballerina, { small: 20, medium: 15, large: 12 });
catalog.set(prettyPolly, { small: 31, medium: 14, large: 24 });
catalog.set(willowVale, { small: 3, medium: 5, large: 0 });
catalog.set(hidcote, { small: 33, medium: 13, large: 18 });
catalog.set(imperialGem, { small: 19, medium: 35, large: 28 });
catalog.set(royalCrown, { small: 40, medium: 22, large: 9 });

const sellPlants = (plant, size, potsNo) => {
    if (!catalog.has(plant)) return "Item not found.";
    const name = `${plant.scientificName} '${plant.cultivar}'`
    const pots = catalog.get(plant);
    if (pots[size] - potsNo < 0) {
        return `Not enough ${size} size pots for ${name}. Only ${pots[size]} left.`
    }
    pots[size] -= potsNo;
    return `Catalog successfully updated.`
}

const removePlant = plant => catalog.delete(plant);

const displayCatalog = () => {
    let catalogString = "";
    catalog.forEach((val, key) => {
        catalogString += `${key.scientificName} '${key.cultivar}': ${val.small} S, ${val.medium} M, ${val.large} L
`
    })
    return catalogString
}
--fcc-editable-region--
const displayPlantsSet = () => {
    const catalogSet = new Set();
    catalogSet.add(ballerina);

    return catalogSet
};

const plantsSet = displayPlantsSet();
console.log(plantsSet);
--fcc-editable-region--
```
