---
id: 67351225403acd3d6f70ed6d
title: Step 20
challengeType: 1
dashedName: step-20
---

# --description--

If you need to loop through the values of your map object, you can use the `values` method instead.

Modify your function to iterate over the values stored in your catalog and log each of them to the console.

# --hints--

Your `displayCatalog` function should call the `values` method on `catalog`.

```js
const catalogCopy = new Map(catalog);
let flag = false;
const temp = catalog.values;
try {
    catalog.values = () => {
        flag = true;
        return catalogCopy.values()
    };
    displayCatalog();    
    assert.isTrue(flag);
} finally {
    catalog.values = temp;
}
```

Your `displayCatalog` function should log each value contained in `catalog` to the console.

```js
const testArr = [];
const temp = console.log;
try {
    console.log = obj => {testArr.push(obj)};
    displayCatalog();    
    assert.isNotEmpty(testArr);
    const v = catalog.values();
    for (let i = 0; i < catalog.size; i++) {
        assert.strictEqual(testArr[i], v.next().value)
    }
} finally {
    console.log = temp;
}
```

# --seed--

## --seed-contents--

```js
const ballerina = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Ballerina"
}

const prettyPolly = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Pretty Polly"
}

const willowVale = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Willow Vale"
}

const hidcote = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Hidcote"
}

const imperialGem = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Imperial Gem"
}

const royalCrown = {
    commonName: "French lavender",
    scientificName: "Lavandula dentata",
    cultivar: "Royal Crown"
}

const catalog = new Map();
catalog.set(ballerina, { small: 20, medium: 15, large: 12 });
catalog.set(prettyPolly, { small: 31, medium: 14, large: 24 });
catalog.set(willowVale, { small: 3, medium: 5, large: 0 });
catalog.set(hidcote, { small: 33, medium: 13, large: 18 });
catalog.set(imperialGem, { small: 19, medium: 35, large: 28 });
catalog.set(royalCrown, { small: 40, medium: 22, large: 9 });

const removePlant = plant => catalog.delete(plant);

const sellPlants = (plant, size, potsNo) => {
    if (!catalog.has(plant)) return "Item not found.";
    const name = `${plant.scientificName} '${plant.cultivar}'`
    const pots = catalog.get(plant);
    if (pots[size] - potsNo < 0) {
        return `Not enough ${size} size pots for ${name}. Only ${pots[size]} left.`
    }
    pots[size] -= potsNo;
    return `Catalog successfully updated.`
}

--fcc-editable-region--
const displayCatalog = () => {
    for (const key of catalog.keys()) {
        console.log(key)
    }
}
--fcc-editable-region--
displayCatalog()
```
