---
id: 6734fa225c6667121e589f7e
title: Step 17
challengeType: 1
dashedName: step-17
---

# --description--

Your `sellPlants` function is raising a `TypeError` because is trying to read a property of an object that has been deleted from the catalog. So, you'll need to take care of the case in which a key is not found in your `catalog` map. For that, the `has` method comes in handy. It returns a boolean indicating whether the specified key exists in the map or not.

Modify your `sellPlants` function to return `Item not found.` when the catalog does not contain the plant passed to the function.

# --hints--

Your `sellPlants` function should call the `has` method on `catalog`.

```js
let flag = false;
const temp = catalog.has;
try {
    catalog.has = (p) => {flag = true}
    sellPlants("test", "", 0);
    sellPlants(imperialGem, "medium", 200);
    assert.isTrue(flag);
} finally {
    catalog.has = temp;
}
```

You should not directly modify the key-value pairs inserted in your `catalog` map.

```js
const testCatalog = new Map();
testCatalog.set(prettyPolly, { small: 31, medium: 14, large: 24 });
testCatalog.set(willowVale, { small: 3, medium: 5, large: 0 });
testCatalog.set(hidcote, { small: 33, medium: 13, large: 18 });
testCatalog.set(imperialGem, { small: 19, medium: 35, large: 28 });
testCatalog.set(royalCrown, { small: 40, medium: 22, large: 9 });
assert.deepEqual(catalog, testCatalog);
```

`sellPlants(ballerina, "small", 10)` should return `Item not found.`.

```js
assert.equal(sellPlants(ballerina, "small", 10), "Item not found.")
```

`sellPlants(hidcote, "large", 95)` should return `Not enough large size pots for Lavandula angustifolia 'Hidcote'. Only 18 left.`.

```js
assert.equal(sellPlants(hidcote, "large", 95), "Not enough large size pots for Lavandula angustifolia 'Hidcote'. Only 18 left.")
assert.equal(sellPlants(royalCrown, "medium", 95), "Not enough medium size pots for Lavandula dentata 'Royal Crown'. Only 22 left.")
```

`sellPlants(hidcote, "large", 5)` should return `Catalog successfully updated.` and subtract `5` from the `large` property of the object associated with the `hidcote` key in the catalog.

```js
try {
    assert.equal(sellPlants(hidcote, "large", 5), "Catalog successfully updated.");
    assert.strictEqual(catalog.get(hidcote).large, 13);

    assert.equal(sellPlants(royalCrown, "medium", 5), "Catalog successfully updated.");
    assert.strictEqual(catalog.get(royalCrown).medium, 17);
} finally {
    catalog.set(hidcote, { small: 33, medium: 13, large: 18 });
    catalog.set(royalCrown, { small: 40, medium: 22, large: 9 });
}
```

# --seed--

## --seed-contents--

```js
const ballerina = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Ballerina"
}

const prettyPolly = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Pretty Polly"
}

const willowVale = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Willow Vale"
}

const hidcote = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Hidcote"
}

const imperialGem = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Imperial Gem"
}

const royalCrown = {
    commonName: "French lavender",
    scientificName: "Lavandula dentata",
    cultivar: "Royal Crown"
}

const catalog = new Map();
catalog.set(ballerina, { small: 20, medium: 15, large: 12 });
catalog.set(prettyPolly, { small: 31, medium: 14, large: 24 });
catalog.set(willowVale, { small: 3, medium: 5, large: 0 });
catalog.set(hidcote, { small: 33, medium: 13, large: 18 });
catalog.set(imperialGem, { small: 19, medium: 35, large: 28 });
catalog.set(royalCrown, { small: 40, medium: 22, large: 9 });

const removePlant = plant => catalog.delete(plant);

console.log(removePlant(ballerina));
--fcc-editable-region--
const sellPlants = (plant, size, potsNo) => {

    const name = `${plant.scientificName} '${plant.cultivar}'`
    const pots = catalog.get(plant);
    if (pots[size] - potsNo < 0) {
        return `Not enough ${size} size pots for ${name}. Only ${pots[size]} left.`
    }
    pots[size] -= potsNo;
    return `Catalog successfully updated.`
}
--fcc-editable-region--
console.log(sellPlants(ballerina, "small", 10));

console.log(catalog)
```
