---
id: 6734f0ae9d1cf4dfd43a7805
title: Step 15
challengeType: 1
dashedName: step-15
---

# --description--

To remove an element from a map object, you can use the `delete` method, which takes a key as argument and removes the entry associated with that key. It returns a boolean indicating if the removal has been successful.

Create a function named `removePlant` that takes a plant object as its argument and removes it from the catalog. Make it return either `true` or `false` depending on if the specified plant has been deleted from the catalog.

After that, log the result of calling your new function with the string `"ballerina"` as its argument.

# --hints--

You should have a function named `removePlant`.

```js
assert.isFunction(removePlant);
```

Your `removePlant` function should take a single argument.

```js
assert.lengthOf(removePlant, 1);
```

Your `removePlant` function should call the `delete` method on `catalog`.

```js
let flag = false;
const temp = catalog.delete;
try {
    catalog.delete = (p) => {flag = true}
    removePlant("");
    assert.isTrue(flag);
} finally {
    catalog.delete = temp;
}
```

`removePlant(item)` should delete `item` from your catalog.

```js
const testArr = [];
const temp = catalog.delete;
try {
    catalog.delete = (p) => {testArr.push(p)}
    removePlant("test");
    assert.deepEqual(testArr, ["test"]);
} finally {
    catalog.delete = temp;
}
```

Your `removePlant` function should return a boolean value indicating if the removal has been successful.

```js
try {
    assert.isFalse(removePlant("test"));
    assert.isTrue(removePlant(royalCrown));
} finally {
    catalog.set(royalCrown, { small: 40, medium: 22, large: 9 })
}
```

You should log `removePlant("ballerina")` to the console.

```js
assert.match(__helpers.removeJSComments(code), /console\s*\.\s*log\s*\(\s*removePlant\s*\(\s*("|')ballerina\1\s*\)\s*\)/);
```



# --seed--

## --seed-contents--

```js
const ballerina = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Ballerina"
}

const prettyPolly = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Pretty Polly"
}

const willowVale = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Willow Vale"
}

const hidcote = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Hidcote"
}

const imperialGem = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Imperial Gem"
}

const royalCrown = {
    commonName: "French lavender",
    scientificName: "Lavandula dentata",
    cultivar: "Royal Crown"
}

const catalog = new Map();
catalog.set(ballerina, { small: 20, medium: 15, large: 12 });
catalog.set(prettyPolly, { small: 31, medium: 14, large: 24 });
catalog.set(willowVale, { small: 3, medium: 5, large: 0 });
catalog.set(hidcote, { small: 33, medium: 13, large: 18 });
catalog.set(imperialGem, { small: 19, medium: 35, large: 28 });
catalog.set(royalCrown, { small: 40, medium: 22, large: 9 });

--fcc-editable-region--

--fcc-editable-region--

const sellPlants = (plant, size, potsNo) => {
    const name = `${plant.scientificName} '${plant.cultivar}'`
    const pots = catalog.get(plant);
    if (pots[size] - potsNo < 0) {
        return `Not enough ${size} size pots for ${name}. Only ${pots[size]} left.`
    }
    pots[size] -= potsNo;
    return `Catalog successfully updated.`
}

console.log(sellPlants(ballerina, "small", 10));

console.log(catalog)
```
