---
id: 6734eee1f9498cd90f9ae340
title: Step 14
challengeType: 1
dashedName: step-14
---

# --description--

When there are enough pots to sell you need to update the catalog by subtracting the pots of the specified size. In that case, return `Catalog successfully updated.`.

Modify your function to achieve that. Then, update your function call by passing `10` as third argument instead of `25`.

# --hints--

You should log `sellPlants(ballerina, "small", 10)` to the console.

```js
assert.match(__helpers.removeJSComments(code), /console\s*\.\s*log\s*\(\s*sellPlants\s*\(\s*ballerina\s*,\s*("|')small\1\s*,\s*10\s*\)\s*\)/);
```

You should have only one `sellPlants` call in your code.

```js
assert.lengthOf(__helpers.removeJSComments(code).match(/(?<!function\s+)sellPlants\s*\(/g), 1)
```

`sellPlants(ballerina, "small", 25)` should return `Not enough small size pots for Lavandula stoechas 'Ballerina'. Only 10 left.`.

```js
assert.equal(sellPlants(ballerina, "small", 25), "Not enough small size pots for Lavandula stoechas 'Ballerina'. Only 10 left.")

// prevent hardcoding
assert.equal(sellPlants(hidcote, "large", 95), "Not enough large size pots for Lavandula angustifolia 'Hidcote'. Only 18 left.")
assert.equal(sellPlants(royalCrown, "medium", 95), "Not enough medium size pots for Lavandula dentata 'Royal Crown'. Only 22 left.")
```

`sellPlants(ballerina, "small", 10)` should return `Catalog successfully updated.` and subtract `10` from the `small` property of the object associated with the `ballerina` key in the catalog.

```js
try {
    assert.equal(sellPlants(ballerina, "small", 10), "Catalog successfully updated.");
    assert.strictEqual(catalog.get(ballerina).small, 0);

    // prevent hardcoding
    assert.equal(sellPlants(hidcote, "large", 5), "Catalog successfully updated.");
    assert.strictEqual(catalog.get(hidcote).large, 13);

    assert.equal(sellPlants(royalCrown, "medium", 5), "Catalog successfully updated.");
    assert.strictEqual(catalog.get(royalCrown).medium, 17);
} finally {
    catalog.set(ballerina, { small: 10, medium: 15, large: 12 });
    catalog.set(hidcote, { small: 33, medium: 13, large: 18 });
    catalog.set(royalCrown, { small: 40, medium: 22, large: 9 });
}
```

You should not directly modify the key-value pairs inserted in your `catalog` map.

```js
const testCatalog = new Map();
testCatalog.set(ballerina, { small: 10, medium: 15, large: 12 });
testCatalog.set(prettyPolly, { small: 31, medium: 14, large: 24 });
testCatalog.set(willowVale, { small: 3, medium: 5, large: 0 });
testCatalog.set(hidcote, { small: 33, medium: 13, large: 18 });
testCatalog.set(imperialGem, { small: 19, medium: 35, large: 28 });
testCatalog.set(royalCrown, { small: 40, medium: 22, large: 9 });
assert.deepEqual(catalog, testCatalog);
```

# --seed--

## --seed-contents--

```js
const ballerina = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Ballerina"
}

const prettyPolly = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Pretty Polly"
}

const willowVale = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Willow Vale"
}

const hidcote = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Hidcote"
}

const imperialGem = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Imperial Gem"
}

const royalCrown = {
    commonName: "French lavender",
    scientificName: "Lavandula dentata",
    cultivar: "Royal Crown"
}

const catalog = new Map();
catalog.set(ballerina, { small: 20, medium: 15, large: 12 });
catalog.set(prettyPolly, { small: 31, medium: 14, large: 24 });
catalog.set(willowVale, { small: 3, medium: 5, large: 0 });
catalog.set(hidcote, { small: 33, medium: 13, large: 18 });
catalog.set(imperialGem, { small: 19, medium: 35, large: 28 });
catalog.set(royalCrown, { small: 40, medium: 22, large: 9 });
--fcc-editable-region--
const sellPlants = (plant, size, potsNo) => {
    const name = `${plant.scientificName} '${plant.cultivar}'`
    const pots = catalog.get(plant);
    if (pots[size] - potsNo < 0) {
        return `Not enough ${size} size pots for ${name}. Only ${pots[size]} left.`
    }
}

console.log(sellPlants(ballerina, "small", 25));
--fcc-editable-region--
console.log(catalog)
```
