---
id: 6734a13a29acdf47f2b8e161
title: Step 6
challengeType: 1
dashedName: step-6
---

# --description--

Unlike regular objects, for which keys must always be strings, map objects allow you to use any datatype as keys. In your catalog, you're going to use object-object key-value pairs, associating each of your plant object with an object containing the number of available pots for different sizes.

Modify your `set` call to use your `ballerina` object as key. For the value, use an object containing three properties, `small`, `medium`, and `large`, each with the value of a positive integer. 

# --hints--

You should set your `ballerina` object as a key of your `catalog` map.

```js
assert.isTrue(catalog.has(ballerina));
```

The value of the `ballerina` key in the `catalog` map should be an object with the properties `small`, `medium`, and `large`.

```js
const b = catalog.get(ballerina)
assert.property(b, "small");
assert.property(b, "medium");
assert.property(b, "large");
```

The `small` property of the object associated with the `ballerina` key in the `catalog` map should be a positive integer.

```js
const b = catalog.get(ballerina)
assert.isTrue(Number.isInteger(b.small));
assert.isAtLeast(b.small, 0);
```

The `medium` property of the object associated with the `ballerina` key in the `catalog` map should be a positive integer.

```js
const b = catalog.get(ballerina)
assert.isTrue(Number.isInteger(b.medium));
assert.isAtLeast(b.medium, 0);
```

The `large` property of the object associated with the `ballerina` key in the `catalog` map should be a positive integer.

```js
const b = catalog.get(ballerina)
assert.isTrue(Number.isInteger(b.large));
assert.isAtLeast(b.large, 0);
```

Your `catalog` map should contain a single key-value pair.

```js
assert.lengthOf(catalog, 1);
```

# --seed--

## --seed-contents--

```js
const ballerina = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Ballerina"
}

const prettyPolly = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Pretty Polly"
}

const willowVale = {
    commonName: "Spanish lavender",
    scientificName: "Lavandula stoechas",
    cultivar: "Willow Vale"
}

const hidcote = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Hidcote"
}

const imperialGem = {
    commonName: "English lavender",
    scientificName: "Lavandula angustifolia",
    cultivar: "Imperial Gem"
}

const royalCrown = {
    commonName: "French lavender",
    scientificName: "Lavandula dentata",
    cultivar: "Royal Crown"
}
--fcc-editable-region--
const catalog = new Map();
catalog.set("ballerina", ballerina);
--fcc-editable-region--
console.log(catalog);
console.log(catalog.size);
```
