---
id: 685c560bfde79c78a3f01a64
title: Step 20
challengeType: 0
dashedName: step-20
---

# --description--

Since `associatedPanel` is an `id`, that will allow you to query the document and find the corresponding panel element. 

Create a new variable called `panel` and assign it the value of `document.getElementById(associatedPanel)`. 

# --hints--

You should have a variable called `panel` that holds the panel element associated with the clicked tab.

```js
assert.match(code, /(?:const|let|var)\s+panel\s*=\s*document\.getElementById\(associatedPanel\);?/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Planets Facts</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <div class="tabs">
      <h2 id="tabs-title">Planets</h2>
      <div role="tablist" aria-labelledby="tabs-title">
        <button role="tab" aria-controls="panel-earth" aria-selected="true" id="tab-earth">🌍 Earth</button>
        <button role="tab" aria-controls="panel-saturn" aria-selected="false" id="tab-saturn">🪐 Saturn</button>
        <button role="tab" aria-controls="panel-mars" aria-selected="false" id="tab-mars">🔴 Mars</button>
      </div>

      <div id="panel-earth" role="tabpanel" aria-labelledby="tab-earth">
        <p>
          Earth is our home planet, known for its abundant water, diverse ecosystems, and life-supporting atmosphere. It's the only planet in the solar system known to harbor life.
        </p>
      </div>
      <div id="panel-saturn" role="tabpanel" aria-labelledby="tab-saturn" hidden>
        <p>
          Saturn is famous for its beautiful and extensive ring system made of ice and rock particles. It's a gas giant with dozens of moons orbiting it.
        </p>
      </div>
      <div id="panel-mars" role="tabpanel" aria-labelledby="tab-mars" hidden>
        <p>
          Mars, the red planet, is a rocky world with the tallest volcano and deepest canyon in the solar system. It's a key focus for exploration in the search for past or present life.
        </p>
      </div>
    </div>

    <script src="./script.js"></script>
  </body>
</html>
```

```css
.tabs [role="tablist"] {
  display: flex;
  gap: 0.5rem;
  margin-bottom: 1rem;
}

[role="tab"] {
  padding: 0.5rem 1rem;
  background: #eee;
  border: 1px solid #ccc;
  cursor: pointer;
  font-weight: bold;
}

[role="tab"][aria-selected="true"] {
  background: #fff;
  border-bottom: 2px solid dodgerblue;
}

[role="tabpanel"] {
  border: 1px solid #ccc;
  padding: 1rem;
}
```

```js
const tabs = document.querySelectorAll('[role="tab"]');
const panels = document.querySelectorAll('[role="tabpanel"]');

--fcc-editable-region--
tabs.forEach(tab => {
  tab.addEventListener("click", () => {
    tabs.forEach(t => t.setAttribute("aria-selected", "false"));
    panels.forEach(p => p.hidden = true);

    tab.setAttribute("aria-selected", "true");
    const associatedPanel = tab.getAttribute("aria-controls");

  });
});
--fcc-editable-region--
```
