---
id: 685c454eb1e7fb7341f1c6ae
title: Step 15
challengeType: 0
dashedName: step-15
---

# --description--

Each `tab` represents one of the buttons in the tab list. The user should be able to click on a tab to display the corresponding panel and hide the others.

In earlier modules, you learned how to attach a `"click"` event listener to each button in a `NodeList` like this:

```js
const btns = document.querySelectorAll("button");
btns.forEach(btn => {
  btn.addEventListener("click", () => {
    // do something when the button is clicked
  });
});
```

Use the `addEventListener` method to attach a `"click"` event listener to each `tab` button. The second argument of the `addEventListener` method should be an empty arrow function `() => {}` for now.

# --hints--

You should have a `tab.addEventListener('click', () => {})` inside the `forEach` loop.

```js
assert.match(code, /tab\.addEventListener\(["']click["']\s*,\s*\(\)\s*=>\s*\{\s*/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Planets Facts</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <div class="tabs">
      <h2 id="tabs-title">Planets</h2>
      <div role="tablist" aria-labelledby="tabs-title">
        <button role="tab" aria-controls="panel-earth" aria-selected="true" id="tab-earth">🌍 Earth</button>
        <button role="tab" aria-controls="panel-saturn" aria-selected="false" id="tab-saturn">🪐 Saturn</button>
        <button role="tab" aria-controls="panel-mars" aria-selected="false" id="tab-mars">🔴 Mars</button>
      </div>

      <div id="panel-earth" role="tabpanel" aria-labelledby="tab-earth">
        <p>
          Earth is our home planet, known for its abundant water, diverse ecosystems, and life-supporting atmosphere. It's the only planet in the solar system known to harbor life.
        </p>
      </div>
      <div id="panel-saturn" role="tabpanel" aria-labelledby="tab-saturn" hidden>
        <p>
          Saturn is famous for its beautiful and extensive ring system made of ice and rock particles. It's a gas giant with dozens of moons orbiting it.
        </p>
      </div>
      <div id="panel-mars" role="tabpanel" aria-labelledby="tab-mars" hidden>
        <p>
          Mars, the red planet, is a rocky world with the tallest volcano and deepest canyon in the solar system. It's a key focus for exploration in the search for past or present life.
        </p>
      </div>
    </div>

    <script src="script.js"></script>
  </body>
</html>
```

```css
.tabs [role="tablist"] {
  display: flex;
  gap: 0.5rem;
  margin-bottom: 1rem;
}

[role="tab"] {
  padding: 0.5rem 1rem;
  background: #eee;
  border: 1px solid #ccc;
  cursor: pointer;
  font-weight: bold;
}

[role="tab"][aria-selected="true"] {
  background: #fff;
  border-bottom: 2px solid dodgerblue;
}

[role="tabpanel"] {
  border: 1px solid #ccc;
  padding: 1rem;
}
```

```js
const tabs = document.querySelectorAll('[role="tab"]');
const panels = document.querySelectorAll('[role="tabpanel"]');

--fcc-editable-region--
tabs.forEach(tab => {

});
--fcc-editable-region--
```
