---
id: 68599d0fcd5f6ac313d05908
title: Step 5
challengeType: 0
dashedName: step-5
---

# --description--

When a user selects a tab, the `aria-selected` attribute should be updated to `"true"` for that tab and `"false"` for all others. This indicates which tab is currently active and ensures accessibility for assistive technologies.

By default, the first tab should be selected. You can do this by adding the `aria-selected` attribute to the first `button` element and setting its value to `"true"`.

# --hints--

Your first `button` element should have an `aria-selected` attribute.

```js
assert.isTrue(
  document.querySelectorAll("[role='tab']")[0].hasAttribute("aria-selected")
);
```

Your first `button` element should have an `aria-selected` attribute set to `"true"`.

```js
const firstBtn = document.querySelectorAll("[role='tab']")[0];
assert.equal(firstBtn.getAttribute("aria-selected"), "true");
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Planets Facts</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <div class="tabs">
      <h2 id="tabs-title">Planets</h2>
      <div role="tablist" aria-labelledby="tabs-title">
        --fcc-editable-region--
        <button role="tab" aria-controls="panel-earth">🌍 Earth</button>
        --fcc-editable-region--
        <button role="tab" aria-controls="panel-saturn">🪐 Saturn</button>
        <button role="tab" aria-controls="panel-mars">🔴 Mars</button>
      </div>
    </div>

    <script src="./script.js"></script>
  </body>
</html>
```

```css
.tabs [role="tablist"] {
  display: flex;
  gap: 0.5rem;
  margin-bottom: 1rem;
}

[role="tab"] {
  padding: 0.5rem 1rem;
  background: #eee;
  border: 1px solid #ccc;
  cursor: pointer;
  font-weight: bold;
}

[role="tab"][aria-selected="true"] {
  background: #fff;
  border-bottom: 2px solid dodgerblue;
}

[role="tabpanel"] {
  border: 1px solid #ccc;
  padding: 1rem;
}
```
