---
id: 68599af28ead38c22590a89d
title: Step 4
challengeType: 0
dashedName: step-4
---

# --description--

There needs to be a way to connect the buttons to the content they represent. This is done by using the `aria-controls` attribute on each button. Later on, you will add the content and the corresponding `id` attributes to the content elements.

Start by adding the `aria-controls` attribute to each of the `button` elements. The value for the first button's `aria-controls` attribute should be set to `"panel-earth"`. The second button's `aria-controls` attribute should be set to `"panel-saturn"`. The third button's `aria-controls` attribute should be set to `"panel-mars"`.

# --hints--

Each of your `button` elements should have an `aria-controls` attribute.

```js
const btns = document.querySelectorAll("div[role='tablist'] button[aria-controls]");
assert.lengthOf(btns, 3);
```

The first `button` element should have an `aria-controls` attribute set to `"panel-earth"`.

```js
const firstBtn = document.querySelectorAll("[role='tab']")[0];
assert.equal(firstBtn.getAttribute("aria-controls"), "panel-earth");
``` 

The second `button` element should have an `aria-controls` attribute set to `"panel-saturn"`.

```js
const secondBtn = document.querySelectorAll("[role='tab']")[1];
assert.equal(secondBtn.getAttribute("aria-controls"), "panel-saturn");
```

The third `button` element should have an `aria-controls` attribute set to `"panel-mars"`.

```js
const thirdBtn = document.querySelectorAll("[role='tab']")[2];
assert.equal(thirdBtn.getAttribute("aria-controls"), "panel-mars");
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Planets Facts</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <div class="tabs">
      <h2 id="tabs-title">Planets</h2>
      <div role="tablist" aria-labelledby="tabs-title">
        --fcc-editable-region--
        <button role="tab">🌍 Earth</button>
        <button role="tab">🪐 Saturn</button>
        <button role="tab">🔴 Mars</button>
        --fcc-editable-region--
      </div>
    </div>

    <script src="./script.js"></script>
  </body>
</html>
```

```css
.tabs [role="tablist"] {
  display: flex;
  gap: 0.5rem;
  margin-bottom: 1rem;
}

[role="tab"] {
  padding: 0.5rem 1rem;
  background: #eee;
  border: 1px solid #ccc;
  cursor: pointer;
  font-weight: bold;
}

[role="tab"][aria-selected="true"] {
  background: #fff;
  border-bottom: 2px solid dodgerblue;
}

[role="tabpanel"] {
  border: 1px solid #ccc;
  padding: 1rem;
}
```
