---
id: 68eb2161d02d00c013fc44f9
title: Step 24
challengeType: 0
dashedName: step-24
---

# --description--

To make the `legend` text more prominent, you need to style it.

Select the `fieldset legend` element. Set its `font-size` to `1.3rem` and its `font-weight` to `600`.

`font-weight` controls the boldness of text. 

Common values of `font-weight` are:

- `normal` → Regular weight (default)
- `bold` → Bold text
- `lighter` → Lighter than the parent element
- `bolder` → Bolder than the parent element
- Numeric values like:
  - `100` (thin)
  - `400` (normal)
  - `700` (bold)
  - `900` (extra bold)

# --hints--

You should have a `fieldset legend` selector.

```js
assert(new __helpers.CSSHelp(document).getStyle('fieldset legend'));
```

Set the `font-size` property to `1.3rem`.

```js
const style = new __helpers.CSSHelp(document).getStyle('fieldset legend');
assert.strictEqual(style?.fontSize, '1.3rem');
```

Set the `font-weight` property to `600`.

```js
const style = new __helpers.CSSHelp(document).getStyle('fieldset legend');
assert.strictEqual(style?.fontWeight, '600');
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Parent Teacher Conference Form</title>
  <link rel="stylesheet" href="./styles.css" />
</head>

<body>
  <main class="container">
    <h1 class="title center">Parent Teacher Conference Form</h1>
    <p class="description center">Please fill out the form below to help schedule your parent-teacher conference.</p>

    <form>
      <fieldset>
        <legend>Student Information</legend>
        <label for="student-name">Full Name: </label>
        <input
            type="text"
            name="student-name"
            id="student-name"
            required
            placeholder="E.g., Jane Doe"
          />

        <label for="grade">Student Grade: </label>
        <input
            type="number"
            name="grade"
            id="grade"
            required
            placeholder="E.g., 4"
          />
      </fieldset>

      <fieldset>
        <legend>Parent/Guardian Information</legend>
        <label for="parent-name">Parent/Guardian Information: </label>
        <input
            type="text"
            name="parent-name"
            id="parent-name"
            required
            placeholder="E.g., Nancy Doe"
          />
      </fieldset>

      <fieldset>
        <legend>Preferred Contact Method</legend>
        <label class="contact-method" for="email">Email: </label>
        <input
            id="email"
            class="contact-method-radio-btn"
            type="radio"
            name="contact-method"
            value="email"
            checked
          />

        <label class="contact-method" for="phone">Phone: </label>
        <input
            id="phone"
            class="contact-method-radio-btn"
            type="radio"
            name="contact-method"
            value="phone"
          />
      </fieldset>

      <fieldset>
        <legend>Additional Notes</legend>
        <label for="notes"
            >Any specific concerns or topics you'd like to discuss?</label>
        <textarea id="notes" name="notes" rows="4" cols="50"></textarea>
      </fieldset>

      <button class="submit-btn" type="submit">Submit Form</button>
    </form>
  </main>
</body>

</html>
```

```css
body {
  background-color: MidnightBlue;
  color: whitesmoke;
}

.container {
    background-color: #ffffff1a;
    width: 80%;
    max-width: 600px;
    border-radius: 10px;
    margin: 20px auto;
    padding: 10px 20px;
    box-shadow: 0 5px 15px black;  
}

.center {
  text-align: center;
}

.description {
  font-size: 1.2rem;
}

fieldset {
  border: 1px solid gray;
  border-radius: 5px;
  margin: 20px 0;
  padding: 20px;
}

--fcc-editable-region--


--fcc-editable-region--
```
