---
id: 67213ce0a2ba1278a38df3a5
title: Step 13
challengeType: 0
dashedName: step-13
---

# --description--

Remove your `console.log` from the event listener and set the inner HTML of `productsContainer` to the result of calling `instrumentCards` with the selected category option.

Then, select different options from your dropdown and see the result in the preview window.

# --before-all--

```js
const allInstrmnts = [
  { category: "woodwinds", instrument: "Flute", price: 500 },
  { category: "woodwinds", instrument: "Clarinet", price: 200 },
  { category: "woodwinds", instrument: "Oboe", price: 4000 },
  { category: "brass", instrument: "Trumpet", price: 200 },
  { category: "brass", instrument: "Trombone", price: 300 },
  { category: "brass", instrument: "French Horn", price: 4300 },
  { category: "percussion", instrument: "Drum Set", price: 500 },
  { category: "percussion", instrument: "Xylophone", price: 3000 },
  { category: "percussion", instrument: "Cymbals", price: 200 },
  { category: "percussion", instrument: "Marimba", price: 3000 }
]
function getCardsArr(family) {
  const instrmnts =
    family === "all"
      ? allInstrmnts
      : allInstrmnts.filter(
          ({ category }) => category === family
        );

  return instrmnts
    .map(({ instrument, price }) => {
      return `
          <div class="card">
            <h2>${instrument}</h2>
            <p>$${price}</p>
          </div>
        `;
    })
}
```

# --hints--

When the dropdown menu option is changed you should set the inner HTML of `productsContainer` to the result of the `instrumentCards` function called with the selected option as argument.

```js
let cardsArr = getCardsArr("all");
const testDiv = document.createElement("div");
testDiv.classList.add("products-container");
testDiv.innerHTML = cardsArr;
selectContainer.value = "all";
selectContainer.dispatchEvent(new Event("change"));
assert.isTrue(productsContainer.isEqualNode(testDiv));

cardsArr = getCardsArr("woodwinds");
testDiv.innerHTML = cardsArr;
selectContainer.value = "woodwinds";
selectContainer.dispatchEvent(new Event("change"));
assert.isTrue(productsContainer.isEqualNode(testDiv));

cardsArr = getCardsArr("brass");
testDiv.innerHTML = cardsArr;
selectContainer.value = "brass";
selectContainer.dispatchEvent(new Event("change"));
assert.isTrue(productsContainer.isEqualNode(testDiv));

cardsArr = getCardsArr("percussion");
testDiv.innerHTML = cardsArr;
selectContainer.value = "percussion";
selectContainer.dispatchEvent(new Event("change"));
assert.isTrue(productsContainer.isEqualNode(testDiv));
```

You should remove `console.log(instrumentCards(selectContainer.value))` from your event listener's callback.

```js
let flag = false;
const temp = console.log;
console.log = (arg) => {
  if (arg === instrumentCards(selectContainer.value)) flag = true;
}
try {
  selectContainer.dispatchEvent(new Event("change"));
  assert.isFalse(flag);
} finally {
  console.log = temp;
}
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Music Instruments product page</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <h1>Student Instruments</h1>

    <main>
      <select class="select-container">
        <option id="all" value="all">All</option>
        <option id="woodwinds" value="woodwinds">Woodwinds</option>
        <option id="brass" value="brass">Brass</option>
        <option id="percussion" value="percussion">Percussion</option>
      </select>

      <div class="products-container">
        <div class="card">
          <h2>Flute</h2>
          <p>$500</p>
        </div>
        <div class="card">
          <h2>Clarinet</h2>
          <p>$200</p>
        </div>
        <div class="card">
          <h2>Oboe</h2>
          <p>$4000</p>
        </div>

        <div class="card">
          <h2>Trumpet</h2>
          <p>$200</p>
        </div>
        <div class="card">
          <h2>Trombone</h2>
          <p>$300</p>
        </div>
        <div class="card">
          <h2>French Horn</h2>
          <p>$4300</p>
        </div>

        <div class="card">
          <h2>Drum Set</h2>
          <p>$500</p>
        </div>
        <div class="card">
          <h2>Xylophone</h2>
          <p>$3000</p>
        </div>
        <div class="card">
          <h2>Cymbals</h2>
          <p>$200</p>
        </div>
        <div class="card">
          <h2>Marimba</h2>
          <p>$3000</p>
        </div>
      </div>
    </main>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
*,
*::before,
*::after {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

:root {
  --dark-grey: #0a0a23;
  --white: #ffffff;
  --yellow: #f1be32;
}

body {
  background-color: var(--dark-grey);
  color: var(--white);
}

h1 {
  text-align: center;
  margin-top: 20px;
}

.select-container {
  display: block;
  margin: 25px auto;
  padding: 8px;
  border: 4px solid var(--white);
  border-radius: 4px;
  width: 200px;
}

.products-container {
  display: flex;
  flex-direction: column;
  flex-wrap: wrap;
  align-items: center;
  justify-content: center;
  gap: 20px;
}

@media (min-width: 760px) {
  .products-container {
    flex-direction: row;
  }
}

.card {
  background-color: var(--white);
  color: var(--dark-grey);
  border: 4px solid var(--yellow);
  border-radius: 5px;
  padding: 10px;
  width: 200px;
}
```

```js
const instrumentsArr = [
  { category: "woodwinds", instrument: "Flute", price: 500 },
  { category: "woodwinds", instrument: "Clarinet", price: 200 },
  { category: "woodwinds", instrument: "Oboe", price: 4000 },
  { category: "brass", instrument: "Trumpet", price: 200 },
  { category: "brass", instrument: "Trombone", price: 300 },
  { category: "brass", instrument: "French Horn", price: 4300 },
  { category: "percussion", instrument: "Drum Set", price: 500 },
  { category: "percussion", instrument: "Xylophone", price: 3000 },
  { category: "percussion", instrument: "Cymbals", price: 200 },
  { category: "percussion", instrument: "Marimba", price: 3000 }
]

const selectContainer = document.querySelector("select");
const productsContainer = document.querySelector(".products-container");

function instrumentCards(instrumentCategory) {
  const instruments =
    instrumentCategory === "all"
      ? instrumentsArr
      : instrumentsArr.filter(
          ({ category }) => category === instrumentCategory
        );

  return instruments
    .map(({ instrument, price }) => {
      return `
          <div class="card">
            <h2>${instrument}</h2>
            <p>$${price}</p>
          </div>
        `;
    })
}
--fcc-editable-region--
selectContainer.addEventListener("change", () => {
  console.log(instrumentCards(selectContainer.value));
});
--fcc-editable-region--
```
