---
id: 6852c7f62711efe79f8a4219
title: Step 43
challengeType: 20
dashedName: step-43
---

# --description--

If you pass invalid data to the `validate` function, for example a list containing non-dictionary elements or dictionaries with missing and/or invalid keys, Python will raise an `AttributeError` and a `TypeError`, respectively. Feel free to verify it by modifying the `medical_records` list.

To avoid that, after setting `is_invalid` to `True`, use the `continue` keyword to skip to the next iteration in both your `if` statements.

# --hints--

You should use the `continue` statement after setting `is_invalid` to `True` in both your `if` statements.

```js
({ test: () => assert(runPython(`
_if_statements = _Node(_code).find_function("validate").find_for_loops()[0].find_bodies()[0].find_ifs()

_if_statements[0].find_bodies()[0].is_ordered("is_invalid = True", "continue") and _if_statements[1].find_bodies()[0].is_ordered("is_invalid = True", "continue")
`)) })
```

# --seed--

## --seed-contents--

```py
import re


medical_records = [
    {
        'patient_id': 'P1001',
        'age': 34,
        'gender': 'Female',
        'diagnosis': 'Hypertension',
        'medications': ['Lisinopril'],
        'last_visit_id': 'V2301',
    },
    {
        'patient_id': 'p1002',
        'age': 47,
        'gender': 'male',
        'diagnosis': 'Type 2 Diabetes',
        'medications': ['Metformin', 'Insulin'],
        'last_visit_id': 'v2302',
    },
    {
        'patient_id': 'P1003',
        'age': 29,
        'gender': 'female',
        'diagnosis': 'Asthma',
        'medications': ['Albuterol'],
        'last_visit_id': 'v2303',
    },
    {
        'patient_id': 'p1004',
        'age': 56,
        'gender': 'Male',
        'diagnosis': 'Chronic Back Pain',
        'medications': ['Ibuprofen', 'Physical Therapy'],
        'last_visit_id': 'V2304',
    }
]


def find_invalid_records(
    patient_id, age, gender, diagnosis, medications, last_visit_id
):

    constraints = {
        'patient_id': isinstance(patient_id, str)
        and re.fullmatch('p\d+', patient_id, re.IGNORECASE),
        'age': isinstance(age, int) and age >= 18,
        'gender': isinstance(gender, str) and gender.lower() in ('male', 'female'),
        'diagnosis': isinstance(diagnosis, str) or diagnosis is None,
        'medications': isinstance(medications, list)
        and all([isinstance(i, str) for i in medications]),
        'last_visit_id': isinstance(last_visit_id, str)
        and re.fullmatch('v\d+', last_visit_id, re.IGNORECASE)
    }

    return [key for key, value in constraints.items() if not value]


def validate(data):
    is_sequence = isinstance(data, (list, tuple))

    if not is_sequence:
        print('Invalid format: expected a list or tuple.')
        return False
        
    is_invalid = False
    key_set = set(
        ['patient_id', 'age', 'gender', 'diagnosis', 'medications', 'last_visit_id']
    )

    for index, dictionary in enumerate(data):
--fcc-editable-region--
        if not isinstance(dictionary, dict):
            print(f'Invalid format: expected a dictionary at position {index}.')
            is_invalid = True

        if set(dictionary.keys()) != key_set:
            print(
                f'Invalid format: {dictionary} at position {index} has missing and/or invalid keys.'
            )
            is_invalid = True

--fcc-editable-region--
        invalid_records = find_invalid_records(**dictionary)

    if is_invalid:
        return False
    print('Valid format.')
    return True

validate(medical_records)
```
