---
id: 68529fb26c581f13e901de3a
title: Step 44
challengeType: 20
dashedName: step-44
---

# --description--

Right after the `invalid_records` variable, create a `for` loop to iterate over it. For each invalid record, print `Unexpected format '<key>: <val>' at position <index>.` (where `<key>`, `<val>`, and `<index>` should be replaced by the current key, value and index). Then, set `is_invalid` to `True`.

Feel free to test the `validate` function with invalid data to see the validation messages. 

With that, the medical validator workshop is complete.

# --hints--

You should have a `for` loop that iterates over `invalid_records`.

```js
({ test: () => assert(runPython(`
_Node(_code).find_function("validate").find_for_loops()[0].find_bodies()[0].find_for_loops()[0].find_for_iter().is_equivalent("invalid_records")
`)) })
```

You should print `Unexpected format '<key>: <val>' at position <index>.` (where `<key>`, `<val>`, and `<index>` should be replaced by the current key, value and index) inside your `for` loop.

```js
({ test: () => runPython(`
built_in_print = print
out = []

def custom_print(*args, **kwargs):
    call_args = [arg for arg in args]
    out.extend(call_args)
    
print = custom_print
_test_data = [
  {'testing': 'stuff'},
  {
    'patient_id': 'P1003',
    'age': 29,
    'gender': 'emale',
    'diagnosis': 'Asthma',
    'medications': ['Albuterol'],
    'last_visit_id': 'V2303',
  },
  {'keep testing': 'stuff'},
  {
    'patient_id': '1003',
    'age': 29,
    'gender': 'female',
    'diagnosis': 'Asthma',
    'medications': 'Albuterol',
    'last_visit_id': 'V2303',
  },
]

validate(_test_data)
print = built_in_print

_first = f"Invalid format: {_test_data[0]} at position 0 has missing and/or invalid keys."
_second = "Unexpected format 'gender: emale' at position 1."
_third = f"Invalid format: {_test_data[2]} at position 2 has missing and/or invalid keys."
_fourth = "Unexpected format 'patient_id: 1003' at position 3."
_fifth = "Unexpected format 'medications: Albuterol' at position 3."

assert len(out) >= 5
assert _first in out
assert _second in out
assert _third in out
assert _fourth in out
assert _fifth in out
`) })
```

You should set `is_invalid` to `True` inside your new `for` loop.

```js
({ test: () => runPython(`
assert _Node(_code).find_function("validate").find_for_loops()[0].find_bodies()[0].find_for_loops()[0].find_bodies()[0].has_stmt("is_invalid = True")
`) })
```


# --seed--

## --seed-contents--

```py
import re


medical_records = [
    {
        'patient_id': 'P1001',
        'age': 34,
        'gender': 'Female',
        'diagnosis': 'Hypertension',
        'medications': ['Lisinopril'],
        'last_visit_id': 'V2301',
    },
    {
        'patient_id': 'p1002',
        'age': 47,
        'gender': 'male',
        'diagnosis': 'Type 2 Diabetes',
        'medications': ['Metformin', 'Insulin'],
        'last_visit_id': 'v2302',
    },
    {
        'patient_id': 'P1003',
        'age': 29,
        'gender': 'female',
        'diagnosis': 'Asthma',
        'medications': ['Albuterol'],
        'last_visit_id': 'v2303',
    },
    {
        'patient_id': 'p1004',
        'age': 56,
        'gender': 'Male',
        'diagnosis': 'Chronic Back Pain',
        'medications': ['Ibuprofen', 'Physical Therapy'],
        'last_visit_id': 'V2304',
    }
]


def find_invalid_records(
    patient_id, age, gender, diagnosis, medications, last_visit_id
):

    constraints = {
        'patient_id': isinstance(patient_id, str)
        and re.fullmatch('p\d+', patient_id, re.IGNORECASE),
        'age': isinstance(age, int) and age >= 18,
        'gender': isinstance(gender, str) and gender.lower() in ('male', 'female'),
        'diagnosis': isinstance(diagnosis, str) or diagnosis is None,
        'medications': isinstance(medications, list)
        and all([isinstance(i, str) for i in medications]),
        'last_visit_id': isinstance(last_visit_id, str)
        and re.fullmatch('v\d+', last_visit_id, re.IGNORECASE)
    }

    return [key for key, value in constraints.items() if not value]


def validate(data):
    is_sequence = isinstance(data, (list, tuple))

    if not is_sequence:
        print('Invalid format: expected a list or tuple.')
        return False
        
    is_invalid = False
    key_set = set(
        ['patient_id', 'age', 'gender', 'diagnosis', 'medications', 'last_visit_id']
    )

    for index, dictionary in enumerate(data):
        if not isinstance(dictionary, dict):
            print(f'Invalid format: expected a dictionary at position {index}.')
            is_invalid = True
            continue

        if set(dictionary.keys()) != key_set:
            print(
                f'Invalid format: {dictionary} at position {index} has missing and/or invalid keys.'
            )
            is_invalid = True
            continue

        invalid_records = find_invalid_records(**dictionary)
--fcc-editable-region--
        
--fcc-editable-region--
    if is_invalid:
        return False
    print('Valid format.')
    return True

validate(medical_records)
```

# --solutions--

```py
import re


medical_records = [
    {
        'patient_id': 'P1001',
        'age': 34,
        'gender': 'Female',
        'diagnosis': 'Hypertension',
        'medications': ['Lisinopril'],
        'last_visit_id': 'V2301',
    },
    {
        'patient_id': 'p1002',
        'age': 47,
        'gender': 'male',
        'diagnosis': 'Type 2 Diabetes',
        'medications': ['Metformin', 'Insulin'],
        'last_visit_id': 'v2302',
    },
    {
        'patient_id': 'P1003',
        'age': 29,
        'gender': 'female',
        'diagnosis': 'Asthma',
        'medications': ['Albuterol'],
        'last_visit_id': 'v2303',
    },
    {
        'patient_id': 'p1004',
        'age': 56,
        'gender': 'Male',
        'diagnosis': 'Chronic Back Pain',
        'medications': ['Ibuprofen', 'Physical Therapy'],
        'last_visit_id': 'V2304',
    }
]


def find_invalid_records(
    patient_id, age, gender, diagnosis, medications, last_visit_id
):

    constraints = {
        'patient_id': isinstance(patient_id, str)
        and re.fullmatch('p\d+', patient_id, re.IGNORECASE),
        'age': isinstance(age, int) and age >= 18,
        'gender': isinstance(gender, str) and gender.lower() in ('male', 'female'),
        'diagnosis': isinstance(diagnosis, str) or diagnosis is None,
        'medications': isinstance(medications, list)
        and all([isinstance(i, str) for i in medications]),
        'last_visit_id': isinstance(last_visit_id, str)
        and re.fullmatch('v\d+', last_visit_id, re.IGNORECASE)
    }

    return [key for key, value in constraints.items() if not value]


def validate(data):
    is_sequence = isinstance(data, (list, tuple))

    if not is_sequence:
        print('Invalid format: expected a list or tuple.')
        return False
        
    is_invalid = False
    key_set = set(
        ['patient_id', 'age', 'gender', 'diagnosis', 'medications', 'last_visit_id']
    )

    for index, dictionary in enumerate(data):
        if not isinstance(dictionary, dict):
            print(f'Invalid format: expected a dictionary at position {index}.')
            is_invalid = True
            continue

        if set(dictionary.keys()) != key_set:
            print(
                f'Invalid format: {dictionary} at position {index} has missing and/or invalid keys.'
            )
            is_invalid = True
            continue

        invalid_records = find_invalid_records(**dictionary)
        for key in invalid_records:
            print(
                f"Unexpected format '{key}: {dictionary.get(key)}' at position {index}."
            )
            is_invalid = True

    if is_invalid:
        return False
    print('Valid format.')
    return True

validate(medical_records)
```
