---
id: 685294b4a1ccb3de0e40410c
title: Step 42
challengeType: 20
dashedName: step-42
---

# --description--

Going back to the `validate` function, after the two `if` statements and still inside the `for` loop, create a variable named `invalid_records`.

Then, assign it a call to `find_invalid_records` using the `**` operator to unpack `dictionary`.

# --hints--

You should have a variable named `invalid_records` at the bottom of your `for` loop inside the `validate` function.

```js
({ test: () => runPython(`
assert _Node(_code).find_function("validate").find_for_loops()[0].find_bodies()[0].has_variable("invalid_records")
`) })
```

Your `invalid_records` variable should have the value of `find_invalid_records(**dictionary)`.

```js
({ test: () => runPython(`
assert _Node(_code).find_function("validate").find_for_loops()[0].find_bodies()[0].find_variable("invalid_records").is_equivalent("invalid_records = find_invalid_records(**dictionary)")
`) })
```

# --seed--

## --seed-contents--

```py
import re


medical_records = [
    {
        'patient_id': 'P1001',
        'age': 34,
        'gender': 'Female',
        'diagnosis': 'Hypertension',
        'medications': ['Lisinopril'],
        'last_visit_id': 'V2301',
    },
    {
        'patient_id': 'p1002',
        'age': 47,
        'gender': 'male',
        'diagnosis': 'Type 2 Diabetes',
        'medications': ['Metformin', 'Insulin'],
        'last_visit_id': 'v2302',
    },
    {
        'patient_id': 'P1003',
        'age': 29,
        'gender': 'female',
        'diagnosis': 'Asthma',
        'medications': ['Albuterol'],
        'last_visit_id': 'v2303',
    },
    {
        'patient_id': 'p1004',
        'age': 56,
        'gender': 'Male',
        'diagnosis': 'Chronic Back Pain',
        'medications': ['Ibuprofen', 'Physical Therapy'],
        'last_visit_id': 'V2304',
    }
]


def find_invalid_records(
    patient_id, age, gender, diagnosis, medications, last_visit_id
):

    constraints = {
        'patient_id': isinstance(patient_id, str)
        and re.fullmatch('p\d+', patient_id, re.IGNORECASE),
        'age': isinstance(age, int) and age >= 18,
        'gender': isinstance(gender, str) and gender.lower() in ('male', 'female'),
        'diagnosis': isinstance(diagnosis, str) or diagnosis is None,
        'medications': isinstance(medications, list)
        and all([isinstance(i, str) for i in medications]),
        'last_visit_id': isinstance(last_visit_id, str)
        and re.fullmatch('v\d+', last_visit_id, re.IGNORECASE)
    }

    return [key for key, value in constraints.items() if not value]


def validate(data):
    is_sequence = isinstance(data, (list, tuple))

    if not is_sequence:
        print('Invalid format: expected a list or tuple.')
        return False
        
    is_invalid = False
    key_set = set(
        ['patient_id', 'age', 'gender', 'diagnosis', 'medications', 'last_visit_id']
    )

    for index, dictionary in enumerate(data):
        if not isinstance(dictionary, dict):
            print(f'Invalid format: expected a dictionary at position {index}.')
            is_invalid = True

        if set(dictionary.keys()) != key_set:
            print(
                f'Invalid format: {dictionary} at position {index} has missing and/or invalid keys.'
            )
            is_invalid = True
--fcc-editable-region--
        
--fcc-editable-region--
    if is_invalid:
        return False
    print('Valid format.')
    return True

validate(medical_records)
```
