---
id: 68516e3c627b43de8c138ea9
title: Step 38
challengeType: 20
dashedName: step-38
---

# --description--

It's time to use another regular expression. Similarly to what you've already done, use the `and` operator to add an expression to the current value of `constraints['last_visit_id']`.

On the right side of the `and` operator, use the `fullmatch` function from the `re` module to ensure that `last_visit_id` starts with the letter `v` (either lowercase or uppercase) followed by one or more digits.

# --hints--

The `last_visit_id` key of your `constraints` dictionary should have the value of `isinstance(last_visit_id, str) and re.fullmatch('v\d+', last_visit_id, re.IGNORECASE)`.

```js
({ test: () => assert(runPython(`
_target = _Node(_code).find_function("find_invalid_records").find_variable("constraints").tree.value
_keys = [k.value for k in _target.keys]
_index = _keys.index('last_visit_id')
_val = _target.values[_index]
_Node(_val).is_equivalent("isinstance(last_visit_id, str) and re.fullmatch('v\\d+', last_visit_id, re.IGNORECASE)")
`)) })
```

# --seed--

## --seed-contents--

```py
import re


medical_records = [
    {
        'patient_id': 'P1001',
        'age': 34,
        'gender': 'Female',
        'diagnosis': 'Hypertension',
        'medications': ['Lisinopril'],
        'last_visit_id': 'V2301',
    },
    {
        'patient_id': 'p1002',
        'age': 47,
        'gender': 'male',
        'diagnosis': 'Type 2 Diabetes',
        'medications': ['Metformin', 'Insulin'],
        'last_visit_id': 'v2302',
    },
    {
        'patient_id': 'P1003',
        'age': 29,
        'gender': 'female',
        'diagnosis': 'Asthma',
        'medications': ['Albuterol'],
        'last_visit_id': 'v2303',
    },
    {
        'patient_id': 'p1004',
        'age': 56,
        'gender': 'Male',
        'diagnosis': 'Chronic Back Pain',
        'medications': ['Ibuprofen', 'Physical Therapy'],
        'last_visit_id': 'V2304',
    }
]


def find_invalid_records(
    patient_id, age, gender, diagnosis, medications, last_visit_id
):

    constraints = {
        'patient_id': isinstance(patient_id, str) and re.fullmatch('p\d+', patient_id, re.IGNORECASE),
        'age': isinstance(age, int) and age >= 18,
        'gender': isinstance(gender, str) and gender.lower() in ('male', 'female'),
        'diagnosis': isinstance(diagnosis, str) or diagnosis is None,
        'medications': isinstance(medications, list) and all([isinstance(i, str) for i in medications]),
--fcc-editable-region--
        'last_visit_id': isinstance(last_visit_id, str)
--fcc-editable-region--

    }

    return constraints

def validate(data):
    is_sequence = isinstance(data, (list, tuple))

    if not is_sequence:
        print('Invalid format: expected a list or tuple.')
        return False
        
    is_invalid = False
    key_set = set(
        ['patient_id', 'age', 'gender', 'diagnosis', 'medications', 'last_visit_id']
    )

    for index, dictionary in enumerate(data):
        if not isinstance(dictionary, dict):
            print(f'Invalid format: expected a dictionary at position {index}.')
            is_invalid = True

        if set(dictionary.keys()) != key_set:
            print(
                f'Invalid format: {dictionary} at position {index} has missing and/or invalid keys.'
            )
            is_invalid = True

    if is_invalid:
        return False
    print('Valid format.')
    return True

validate(medical_records)
print(find_invalid_records(**medical_records[0]))
```
