---
id: 6846ee2d4d66bda7e22362ab
title: Step 25
challengeType: 20
dashedName: step-25
---

# --description--

A regular expression, or regex, is a pattern used to match a sequence of characters in text. The `search` function from the `re` module takes a regex pattern and a string as its arguments.

It returns a corresponding match object if the pattern produces a match. Otherwise it returns `None`.

```py
import re

greeting = "Hello there!"
print(re.search('Hi', greeting)) # None
print(re.search('Hello', greeting)) # <re.Match object; span=(0, 5), match='Hello'>
```

Call `re.search` with the string `p` as the first argument and `patient_id` as the second argument. Use the `and` operator to add the function call as a second expression to the value of your `patient_id` key.

# --hints--

Your `constraints` dictionary should have a key `patient_id` with the value of `isinstance(patient_id, str) and re.search('p', patient_id)`.

```js
({ test: () => runPython(`
assert _Node(_code).find_function("find_invalid_records").find_variable("constraints").is_equivalent("constraints = {'patient_id': isinstance(patient_id, str) and re.search('p', patient_id)}")
`) })
```

# --seed--

## --seed-contents--

```py
import re


medical_records = [
    {
        'patient_id': 'P1001',
        'age': 34,
        'gender': 'Female',
        'diagnosis': 'Hypertension',
        'medications': ['Lisinopril'],
        'last_visit_id': 'V2301',
    },
    {
        'patient_id': 'p1002',
        'age': 47,
        'gender': 'male',
        'diagnosis': 'Type 2 Diabetes',
        'medications': ['Metformin', 'Insulin'],
        'last_visit_id': 'v2302',
    },
    {
        'patient_id': 'P1003',
        'age': 29,
        'gender': 'female',
        'diagnosis': 'Asthma',
        'medications': ['Albuterol'],
        'last_visit_id': 'v2303',
    },
    {
        'patient_id': 'p1004',
        'age': 56,
        'gender': 'Male',
        'diagnosis': 'Chronic Back Pain',
        'medications': ['Ibuprofen', 'Physical Therapy'],
        'last_visit_id': 'V2304',
    }
]


def find_invalid_records(
    patient_id, age, gender, diagnosis, medications, last_visit_id
):

--fcc-editable-region--
    constraints = {
        'patient_id': isinstance(patient_id, str)
    }
--fcc-editable-region--

    return constraints

def validate(data):
    is_sequence = isinstance(data, (list, tuple))

    if not is_sequence:
        print('Invalid format: expected a list or tuple.')
        return False
        
    is_invalid = False
    key_set = set(
        ['patient_id', 'age', 'gender', 'diagnosis', 'medications', 'last_visit_id']
    )

    for index, dictionary in enumerate(data):
        if not isinstance(dictionary, dict):
            print(f'Invalid format: expected a dictionary at position {index}.')
            is_invalid = True

        if set(dictionary.keys()) != key_set:
            print(
                f'Invalid format: {dictionary} at position {index} has missing and/or invalid keys.'
            )
            is_invalid = True

    if is_invalid:
        return False
    print('Valid format.')
    return True

validate(medical_records)
print(find_invalid_records(**medical_records[0]))
```
