---
id: 6846b0048f71fc4efd786b42
title: Step 18
challengeType: 20
dashedName: step-18
---

# --description--

The `keys()` method returns a view object containing all the keys from a dictionary:

```py
person = {
   'name': 'John',
   'age': 33
}

print(person.keys()) # dict_keys(['name, 'age'])
```

Inside your `for` loop, after the first `if` statement, create an `if` statement that runs when the set of keys from the current dictionary is different from `key_set`. This is to ensure that no missing or invalid keys are present in the dictionary.

Within the new `if` statement, print `Invalid format: <dictionary> at position <index> has missing and/or invalid keys.` (where `<dictionary>` and `<index>` should be replaced by the dictionary and index at the current iteration) and set `is_invalid` to `True`.

# --hints--

You should have a second `if` statement inside your `for` loop.

```js
({ test: () => runPython(`
assert _Node(_code).find_function("validate").find_for_loops()[0].find_bodies()[0].find_ifs()[1]
`) })
```

Your new `if` statement should run when `set(dictionary.keys())` is different from `key_set`.

```js
({ test: () => assert(runPython(`
_condition = _Node(_code).find_function("validate").find_for_loops()[0].find_bodies()[0].find_ifs()[1].find_conditions()[0]

_condition.is_equivalent("set(dictionary.keys()) != key_set") or _condition.is_equivalent("key_set != set(dictionary.keys())")
`)) })
```

You should print `Invalid format: <dictionary> at position <index> has missing and/or invalid keys.` (where `<dictionary>` and `<index>` should be replaced by the dictionary and index at the current iteration) inside your new `if` statement.

```js
({ test: () => assert(runPython(`
built_in_print = print
out = []

def custom_print(*args, **kwargs):
    call_args = [arg for arg in args]
    out.extend(call_args)
    
print = custom_print
_test_data = [
  {'testing': 'stuff'},
  {
    'patient_id': 'P1003',
    'age': 29,
    'gender': 'Female',
    'diagnosis': 'Asthma',
    'medications': ['Albuterol'],
    'last_visit_id': 'V2303',
  },
  {'keep testing': 'stuff'}
]
validate(_test_data)
print = built_in_print

_first = f"Invalid format: {_test_data[0]} at position 0 has missing and/or invalid keys."
_second = f"Invalid format: {_test_data[2]} at position 2 has missing and/or invalid keys."
len(out) >= 2 and _first in out and _second in out
`)) })
```

You should set `is_invalid` to `True` inside your new `if` statement.

```js
({ test: () => runPython(`
assert _Node(_code).find_function("validate").find_for_loops()[0].find_bodies()[0].find_ifs()[1].find_bodies()[0].has_stmt("is_invalid = True")
`) })
```

# --seed--

## --seed-contents--

```py
medical_records = [
    {
        'patient_id': 'P1001',
        'age': 34,
        'gender': 'Female',
        'diagnosis': 'Hypertension',
        'medications': ['Lisinopril'],
        'last_visit_id': 'V2301',
    },
    {
        'patient_id': 'p1002',
        'age': 47,
        'gender': 'male',
        'diagnosis': 'Type 2 Diabetes',
        'medications': ['Metformin', 'Insulin'],
        'last_visit_id': 'v2302',
    },
    {
        'patient_id': 'P1003',
        'age': 29,
        'gender': 'female',
        'diagnosis': 'Asthma',
        'medications': ['Albuterol'],
        'last_visit_id': 'v2303',
    },
    {
        'patient_id': 'p1004',
        'age': 56,
        'gender': 'Male',
        'diagnosis': 'Chronic Back Pain',
        'medications': ['Ibuprofen', 'Physical Therapy'],
        'last_visit_id': 'V2304',
    }   
]


def validate(data):
    is_sequence = isinstance(data, (list, tuple))

    if not is_sequence:
        print('Invalid format: expected a list or tuple.')
        return False
        
    is_invalid = False
    key_set = set(
        ['patient_id', 'age', 'gender', 'diagnosis', 'medications', 'last_visit_id']
    )

    for index, dictionary in enumerate(data):
        if not isinstance(dictionary, dict):
            print(f'Invalid format: expected a dictionary at position {index}.')
            is_invalid = True

--fcc-editable-region--
        
--fcc-editable-region--
    if is_invalid:
        return False
    print('Valid format.')
    return True



validate(medical_records)

```
