---
id: 68b99be831fb229c9d950296
title: Step 42
challengeType: 20
dashedName: step-42
---

# --description--

Using the same logic, create an `if` statement that runs when the `series` list is not empty. Inside it, concatenate the string `=== TV SERIES ===` (ending with a newline character) to the current value of `result`.

Then, create a `for` loop that uses enumeration to add the items in the `series` list to the `result` variable. As you did previously, start indexing the values from `1`.

With that, the media catalogue workshop is complete.

# --hints--

You should have a second `if` statement in your `__str__` method.

```js
({
  test: () => runPython(`
    assert len(_Node(_code).find_class("MediaCatalogue").find_function("__str__").find_ifs()) == 3
  `)
})
```

You should have `result += '=== TV SERIES ===\n'` inside your second `if` statement.

```js
({
  test: () => runPython(`
    assert _Node(_code).find_class("MediaCatalogue").find_function("__str__").find_ifs()[2].find_body().has_stmt("result += '=== TV SERIES ===\\\\n'")
  `)
})
```

You should have a `for` loop in your second `if` statement.

```js
({
  test: () => runPython(`
    assert _Node(_code).find_class("MediaCatalogue").find_function("__str__").find_ifs()[2].find_body().find_for_loops()[0]
  `)
})
```

When `self.items` contains `Movie('Dances with Wolves', 1990, 'Kevin Costner', 224)` and `Movie('Annie Hall', 1977, 'Woody Allen', 93)`, your `__str__` method should return `Media Catalogue (2 items):\n\n=== MOVIES ===\n1. Dances with Wolves (1990) - 224 min, Kevin Costner\n2. Annie Hall (1977) - 93 min, Woody Allen\n`.

```js
({
  test: () => runPython(`
    import io
    import sys
        
    captured_output = io.StringIO()
    sys.stdout = captured_output

    _catalogue = MediaCatalogue()
    _catalogue.add(Movie('Dances with Wolves', 1990, 'Kevin Costner', 224))
    _catalogue.add(Movie('Annie Hall', 1977, 'Woody Allen', 93))
    print(_catalogue)
        
    sys.stdout = sys.__stdout__
    output = captured_output.getvalue()

    _expected = """Media Catalogue (2 items):

    === MOVIES ===
    1. Dances with Wolves (1990) - 224 min, Kevin Costner
    2. Annie Hall (1977) - 93 min, Woody Allen
    """
    assert _expected in output
  `)
})
```

When `self.items` contains `TVSeries("Game of Thrones", 2011, "David Benioff & D.B. Weiss", 57, 8, 73)` and `TVSeries("Stranger Things", 2016, "The Duffer Brothers", 50, 4, 34)`, your `__str__` method should return `Media Catalogue (2 items):\n\n=== TV SERIES ===\n1. Game of Thrones (2011) - 8 seasons, 73 episodes, 57 min avg, David Benioff & D.B. Weiss\n2. Stranger Things (2016) - 4 seasons, 34 episodes, 50 min avg, The Duffer Brothers\n`.

```js
({
  test: () => runPython(`
    import io
    import sys
        
    captured_output = io.StringIO()
    sys.stdout = captured_output

    _catalogue = MediaCatalogue()
    _catalogue.add(TVSeries("Game of Thrones", 2011, "David Benioff & D.B. Weiss", 57, 8, 73))
    _catalogue.add(TVSeries("Stranger Things", 2016, "The Duffer Brothers", 50, 4, 34))
    print(_catalogue)
        
    sys.stdout = sys.__stdout__
    output = captured_output.getvalue()

    _expected = """Media Catalogue (2 items):

    === TV SERIES ===
    1. Game of Thrones (2011) - 8 seasons, 73 episodes, 57 min avg, David Benioff & D.B. Weiss
    2. Stranger Things (2016) - 4 seasons, 34 episodes, 50 min avg, The Duffer Brothers
    """
    assert _expected in output
  `)
})
```

When `self.items` contains `Movie('Barry Lyndon', 1975, 'Stanley Kubrick', 184)`, `Movie('Fahrenheit 451', 1966, 'Francois Truffaut', 112)`, `TVSeries("Game of Thrones", 2011, "David Benioff & D.B. Weiss", 57, 8, 73)` and `TVSeries("Stranger Things", 2016, "The Duffer Brothers", 50, 4, 34)` your `__str__` method should return `Media Catalogue (4 items):\n\n=== MOVIES ===\n1. Barry Lyndon (1975) - 184 min, Stanley Kubrick\n2. Fahrenheit 451 (1966) - 112 min, Francois Truffaut\n=== TV SERIES ===\n1. Game of Thrones (2011) - 8 seasons, 73 episodes, 57 min avg, David Benioff & D.B. Weiss\n2. Stranger Things (2016) - 4 seasons, 34 episodes, 50 min avg, The Duffer Brothers\n`.

```js
({
  test: () => runPython(`
    import io
    import sys
        
    captured_output = io.StringIO()
    sys.stdout = captured_output

    _catalogue = MediaCatalogue()
    _catalogue.add(Movie('Barry Lyndon', 1975, 'Stanley Kubrick', 184))
    _catalogue.add(Movie('Fahrenheit 451', 1966, 'Francois Truffaut', 112))
    _catalogue.add(TVSeries("Game of Thrones", 2011, "David Benioff & D.B. Weiss", 57, 8, 73))
    _catalogue.add(TVSeries("Stranger Things", 2016, "The Duffer Brothers", 50, 4, 34))
    print(_catalogue)
        
    sys.stdout = sys.__stdout__
    output = captured_output.getvalue()

    _expected = """Media Catalogue (4 items):

    === MOVIES ===
    1. Barry Lyndon (1975) - 184 min, Stanley Kubrick
    2. Fahrenheit 451 (1966) - 112 min, Francois Truffaut
    === TV SERIES ===
    1. Game of Thrones (2011) - 8 seasons, 73 episodes, 57 min avg, David Benioff & D.B. Weiss
    2. Stranger Things (2016) - 4 seasons, 34 episodes, 50 min avg, The Duffer Brothers
    """
    assert _expected in output
  `)
})
```

Your `__str__` method should return `Media Catalogue (empty)` when `self.items` is empty.

```js
({
  test: () => runPython(`
    import io
    import sys
        
    captured_output = io.StringIO()
    sys.stdout = captured_output
        
    print(MediaCatalogue())
        
    sys.stdout = sys.__stdout__
    output = captured_output.getvalue()
        
    assert "Media Catalogue (empty)" in output
  `)
})
```

# --seed--

## --seed-contents--

```py
class MediaError(Exception):
    """Custom exception for media-related errors."""

    def __init__(self, message, obj):
        super().__init__(message)
        self.obj = obj

class Movie:
    """Parent class representing a movie."""
    
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'

class TVSeries(Movie):
    """Child class representing an entire TV series."""

    def __init__(self, title, year, director, duration, seasons, total_episodes):
        super().__init__(title, year, director, duration)

        if seasons < 1:
            raise ValueError('Seasons must be 1 or greater')
        if total_episodes < 1:
            raise ValueError('Total episodes must be 1 or greater')
        
        self.seasons = seasons
        self.total_episodes = total_episodes

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.seasons} seasons, {self.total_episodes} episodes, {self.duration} min avg, {self.director}'

class MediaCatalogue:
    """A catalogue that can store different types of media items."""

    def __init__(self):
        self.items = []

    def add(self, media_item):
        if not isinstance(media_item, Movie):
            raise MediaError('Only Movie or TVSeries instances can be added', media_item)
        self.items.append(media_item)

    def get_movies(self):
        return [item for item in self.items if type(item) is Movie]

    def get_tv_series(self):
        return [item for item in self.items if isinstance(item, TVSeries)]
    
    def __str__(self):
        if not self.items:
            return 'Media Catalogue (empty)'
        
        movies = self.get_movies()
        series = self.get_tv_series()

        result = f'Media Catalogue ({len(self.items)} items):\n\n'
--fcc-editable-region--
        if movies:
            result += '=== MOVIES ===\n'
            for i, movie in enumerate(movies, 1):
                result += f'{i}. {movie}\n'
        
        
--fcc-editable-region--
        return result

catalogue = MediaCatalogue()

try:
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)
    catalogue.add(movie1)
    movie2 = Movie('Inception', 2010, 'Christopher Nolan', 148)
    catalogue.add(movie2)

    series1 = TVSeries('Scrubs', 2001, 'Bill Lawrence', 24, 9, 182)
    catalogue.add(series1)
    series2 = TVSeries('Breaking Bad', 2008, 'Vince Gilligan', 47, 5, 62)
    catalogue.add(series2)

    print(catalogue)
except ValueError as e:
    print(f'Validation Error: {e}')
except MediaError as e:
    print(f'Media Error: {e}')
    print(f'Unable to add {e.obj}: {type(e.obj)}')

```

# --solutions--

```py
class MediaError(Exception):
    """Custom exception for media-related errors."""

    def __init__(self, message, obj):
        super().__init__(message)
        self.obj = obj

class Movie:
    """Parent class representing a movie."""
    
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'

class TVSeries(Movie):
    """Child class representing an entire TV series."""

    def __init__(self, title, year, director, duration, seasons, total_episodes):
        super().__init__(title, year, director, duration)

        if seasons < 1:
            raise ValueError('Seasons must be 1 or greater')
        if total_episodes < 1:
            raise ValueError('Total episodes must be 1 or greater')
        
        self.seasons = seasons
        self.total_episodes = total_episodes

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.seasons} seasons, {self.total_episodes} episodes, {self.duration} min avg, {self.director}'

class MediaCatalogue:
    """A catalogue that can store different types of media items."""

    def __init__(self):
        self.items = []

    def add(self, media_item):
        if not isinstance(media_item, Movie):
            raise MediaError('Only Movie or TVSeries instances can be added', media_item)
        self.items.append(media_item)

    def get_movies(self):
        return [item for item in self.items if type(item) is Movie]

    def get_tv_series(self):
        return [item for item in self.items if isinstance(item, TVSeries)]
    
    def __str__(self):
        if not self.items:
            return 'Media Catalogue (empty)'
        
        movies = self.get_movies()
        series = self.get_tv_series()

        result = f'Media Catalogue ({len(self.items)} items):\n\n'

        if movies:
            result += '=== MOVIES ===\n'
            for i, movie in enumerate(movies, 1):
                result += f'{i}. {movie}\n'
        
        if series:
            result += '=== TV SERIES ===\n'
            for i, s in enumerate(series, 1):
                result += f'{i}. {s}\n'

        return result

catalogue = MediaCatalogue()

try:
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)
    catalogue.add(movie1)
    movie2 = Movie('Inception', 2010, 'Christopher Nolan', 148)
    catalogue.add(movie2)

    series1 = TVSeries('Scrubs', 2001, 'Bill Lawrence', 24, 9, 182)
    catalogue.add(series1)
    series2 = TVSeries('Breaking Bad', 2008, 'Vince Gilligan', 47, 5, 62)
    catalogue.add(series2)

    print(catalogue)
except ValueError as e:
    print(f'Validation Error: {e}')
except MediaError as e:
    print(f'Media Error: {e}')
    print(f'Unable to add {e.obj}: {type(e.obj)}')

```
