---
id: 68b99289c744bffa96807d04
title: Step 37
challengeType: 20
dashedName: step-37
---

# --description--

Currently, both movies and tv series are displayed all together when you print the catalogue. In the next steps, you'll take care of filtering the items in two categories to display separately.

Inside the `MediaCatalogue` class, create a method named `get_movies` and make it return a list containing only instances of the parent class `Movie` that can be found in `self.items`.

Use the approach you prefer to do so, but remember to use the `type` function since `isinstance` won't be able to discriminate between parent and child classes.

# --hints--

Your `MediaCatalogue` class should have a method named `get_movies`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("MediaCatalogue").has_function("get_movies")`)
})
```

Your `get_movies` method should return a list containing all the items in `self.items` that are instances of the `Movie` class.

```js
({
  test: () => runPython(`
    m1 = Movie("The Godfather", 1972, "Francis Ford Coppola", 175)
    m2 = Movie("Pulp Fiction", 1994, "Quentin Tarantino", 154)
    s1 = TVSeries("Game of Thrones", 2011, "David Benioff & D.B. Weiss", 57, 8, 73)
    s2 = TVSeries("Stranger Things", 2016, "The Duffer Brothers", 50, 4, 34)
    c = MediaCatalogue()
    c.add(m1)
    c.add(s1)
    c.add(m2)
    c.add(s2)
    movies = c.get_movies()
    assert len(movies) == 2
    assert m1 in movies and m2 in movies
  `)
})
```

# --seed--

## --seed-contents--

```py
class MediaError(Exception):
    """Custom exception for media-related errors."""

    def __init__(self, message, obj):
        super().__init__(message)
        self.obj = obj

class Movie:
    """Parent class representing a movie."""
    
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'

class TVSeries(Movie):
    """Child class representing an entire TV series."""

    def __init__(self, title, year, director, duration, seasons, total_episodes):
        super().__init__(title, year, director, duration)

        if seasons < 1:
            raise ValueError('Seasons must be 1 or greater')
        if total_episodes < 1:
            raise ValueError('Total episodes must be 1 or greater')
        
        self.seasons = seasons
        self.total_episodes = total_episodes

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.seasons} seasons, {self.total_episodes} episodes, {self.duration} min avg, {self.director}'

class MediaCatalogue:
    """A catalogue that can store different types of media items."""

    def __init__(self):
        self.items = []

    def add(self, media_item):
        if not isinstance(media_item, Movie):
            raise MediaError('Only Movie or TVSeries instances can be added', media_item)
        self.items.append(media_item)
--fcc-editable-region--
    
--fcc-editable-region--
    def __str__(self):
        if not self.items:
            return 'Media Catalogue (empty)'

        result = f'Media Catalogue ({len(self.items)} items):\n\n'
        
        for i, movie in enumerate(self.items, 1):
            result += f'{i}. {movie}\n'
        return result

catalogue = MediaCatalogue()

try:
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)
    catalogue.add(movie1)
    movie2 = Movie('Inception', 2010, 'Christopher Nolan', 148)
    catalogue.add(movie2)

    series1 = TVSeries('Scrubs', 2001, 'Bill Lawrence', 24, 9, 182)
    catalogue.add(series1)
    series2 = TVSeries('Breaking Bad', 2008, 'Vince Gilligan', 47, 5, 62)
    catalogue.add(series2)

    print(catalogue)
except ValueError as e:
    print(f'Validation Error: {e}')
except MediaError as e:
    print(f'Media Error: {e}')
    print(f'Unable to add {e.obj}: {type(e.obj)}')

```
