---
id: 68b94e26d2216958479e24bf
title: Step 29
challengeType: 20
dashedName: step-29
---

# --description--

It would be nice to validate the item passed to the `add` method before adding it to the catalogue.

Create an `if` statement that uses `isinstance` to check if `media_item` is an instance of `Movie` and raise a `TypeError` with the message `Only Movie or TVSeries instances can be added`.

Note that `isinstance(obj, ClassName)` returns `True` if `obj` is an instance of `ClassName` or *any of its subclasses*, because it considers the full inheritance chain.

# --hints--

You should raise a `TypeError` with the message `Only Movie or TVSeries instances can be added` when `media_item` is not an instance of `Movie` or its subclasses.

```js
({
  test: () => runPython(`
  _msg = 'Only Movie or TVSeries instances can be added'
  _expected_error = f"Expected to raise 'TypeError: {_msg}'"
  _c = MediaCatalogue()
  try:    
    _c.add("Not a movie")
  except TypeError as e:
    assert str(e) == _msg
  else:
    assert False, _expected_error

  try:
    _c.add({})
  except TypeError as e:
    assert str(e) == _msg
  else:
    assert False, _expected_error
  `)
})
```

You should not raise a `TypeError` when `media_item` is a valid item.

```js
({
    test: () => runPython(`
    _c = MediaCatalogue()
    try:
      _c.add(Movie('The Matrix', 1999, 'The Wachowskis', 136))
    except TypeError:
      assert False, 'Expected not to raise a TypeError with valid media_item'

    try:
      _c.add(TVSeries('Scrubs', 2001, 'Bill Lawrence', 24, 9, 182))
    except TypeError:
      assert False, 'Expected not to raise a TypeError with valid media_item'
    `)
})
```

# --seed--

## --seed-contents--

```py
class Movie:
    """Parent class representing a movie."""
    
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'

class TVSeries(Movie):
    """Child class representing an entire TV series."""

    def __init__(self, title, year, director, duration, seasons, total_episodes):
        super().__init__(title, year, director, duration)

        if seasons < 1:
            raise ValueError('Seasons must be 1 or greater')
        if total_episodes < 1:
            raise ValueError('Total episodes must be 1 or greater')
        
        self.seasons = seasons
        self.total_episodes = total_episodes

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.seasons} seasons, {self.total_episodes} episodes, {self.duration} min avg, {self.director}'

class MediaCatalogue:
    """A catalogue that can store different types of media items."""

    def __init__(self):
        self.items = []
--fcc-editable-region--
    def add(self, media_item):
        
        self.items.append(media_item)
--fcc-editable-region--
    def __str__(self):
        if not self.items:
            return 'Media Catalogue (empty)'

        result = f'Media Catalogue ({len(self.items)} items):\n\n'
        
        for i, movie in enumerate(self.items, 1):
            result += f'{i}. {movie}\n'
        return result

catalogue = MediaCatalogue()

try:
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)
    catalogue.add(movie1)
    movie2 = Movie('Inception', 2010, 'Christopher Nolan', 148)
    catalogue.add(movie2)

    series1 = TVSeries('Scrubs', 2001, 'Bill Lawrence', 24, 9, 182)
    catalogue.add(series1)
    series2 = TVSeries('Breaking Bad', 2008, 'Vince Gilligan', 47, 5, 62)
    catalogue.add(series2)

    print(catalogue)
except ValueError as e:
    print(f'Validation Error: {e}')
```
