---
id: 68b804f3be853a355f055fef
title: Step 18
challengeType: 20
dashedName: step-18
---

# --description--

The `super` function is used to refer to the parent class without naming it explicitly. For example, `super().__init__(arg1, arg2, ...)` calls the `__init__` method defined in the parent class.

At the moment, you have effectively overridden the `__init__` method inherited from `Movie`. This means that a `TVSeries` object will have only a `seasons` attribute and a `total_episodes` attribute. This is not what you want.

To keep all the code defined in the `Movie` class' `__init__`, use `super` to call the parent's `__init__`. Note that you'll need to pass in the arguments required by the method. In this case, `title`, `year`, `director`, and `duration`.

# --hints--

You should call `super().__init__(title, year, director, duration)` inside your `__init__` method.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("TVSeries").find_function("__init__").has_stmt("super().__init__(title, year, director, duration)")`)
})
```

# --seed--

## --seed-contents--

```py
class Movie:
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'
--fcc-editable-region--
class TVSeries(Movie):
    def __init__(self, title, year, director, duration, seasons, total_episodes):
        
        self.seasons = seasons
        self.total_episodes = total_episodes
--fcc-editable-region--
class MediaCatalogue:
    def __init__(self):
        self.items = []

    def add(self, media_item):
        self.items.append(media_item)

    def __str__(self):
        if not self.items:
            return 'Media Catalogue (empty)'

        result = f'Media Catalogue ({len(self.items)} items):\n\n'
        
        for i, movie in enumerate(self.items, 1):
            result += f'{i}. {movie}\n'
        return result

catalogue = MediaCatalogue()

try:
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)
    catalogue.add(movie1)
    movie2 = Movie('Inception', 2010, 'Christopher Nolan', 148)
    catalogue.add(movie2)
    print(catalogue)
except ValueError as e:
    print(f'Validation Error: {e}')
```
