---
id: 68b702892910ab7b495de081
title: Step 11
challengeType: 20
dashedName: step-11
---

# --description--

You'll need a proper way to visually represent the catalogue. So create a `__str__` method in your `MediaCatalogue` class.

If the `items` list is empty, make sure the `__str__` method returns `Media Catalogue (empty)`.

# --hints--

You should have a `__str__` method in your `MediaCatalogue` class.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("MediaCatalogue").has_function("__str__")`)
})
```

Your `__str__` method should return `Media Catalogue (empty)` when `self.items` is empty.

```js
({
  test: () => runPython(`
    import io
    import sys
        
    captured_output = io.StringIO()
    sys.stdout = captured_output
        
    print(MediaCatalogue())
        
    sys.stdout = sys.__stdout__
    output = captured_output.getvalue()
        
    assert "Media Catalogue (empty)" in output
  `)
})
```

Your `__str__` method should not return `Media Catalogue (empty)` when `self.items` is not empty.

```js
({
  test: () => runPython(`
    import io
    import sys
        
    captured_output = io.StringIO()
    sys.stdout = captured_output
    _catalogue = MediaCatalogue()
    _catalogue.add(Movie('The Matrix', 1999, 'The Wachowskis', 136))
    try:
      print(_catalogue)
    except TypeError:
      pass
        
    sys.stdout = sys.__stdout__
    output = captured_output.getvalue()
        
    assert "Media Catalogue (empty)" not in output
  `)
})
```

# --seed--

## --seed-contents--

```py
class Movie:
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'
--fcc-editable-region--
class MediaCatalogue:
    def __init__(self):
        self.items = []

    def add(self, media_item):
        self.items.append(media_item)

    
--fcc-editable-region--
try:
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)
except ValueError as e:
    print(f'Validation Error: {e}')
```
