---
id: 68b6d9692a6526838265ad7f
title: Step 17
challengeType: 20
dashedName: step-17
---

# --description--

A `TVSeries` object will be instantiated with additional attributes with respect to its parent `Movie`. Therefore, create an `__init__` method with the following parameters: `self`, `title`, `year`, `director`, `duration`, `seasons`, and `total_episodes`.

Inside the `__init__` method, assign `seasons` and `total_episodes` to attributes with the same name.

# --hints--

Your `TVSeries` class should have an `__init__` method.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("TVSeries").has_function("__init__")`)
})
```

Your `__init__` method should have the following parameters: `self`, `title`, `year`, `director`, `duration`, `seasons`, and `total_episodes`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("TVSeries").find_function("__init__").has_args("self, title, year, director, duration, seasons, total_episodes")`)
})
```

You should assign `seasons` to `self.seasons` inside your `__init__` method.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("TVSeries").find_function("__init__").has_stmt("self.seasons = seasons")`)
})
```

You should assign `total_episodes` to `self.total_episodes` inside your `__init__` method.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("TVSeries").find_function("__init__").has_stmt("self.total_episodes = total_episodes")`)
})
```

# --seed--

## --seed-contents--

```py
class Movie:
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'
--fcc-editable-region--
class TVSeries(Movie):
    pass
--fcc-editable-region--
class MediaCatalogue:
    def __init__(self):
        self.items = []

    def add(self, media_item):
        self.items.append(media_item)

    def __str__(self):
        if not self.items:
            return 'Media Catalogue (empty)'

        result = f'Media Catalogue ({len(self.items)} items):\n\n'
        
        for i, movie in enumerate(self.items, 1):
            result += f'{i}. {movie}\n'
        return result

catalogue = MediaCatalogue()

try:
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)
    catalogue.add(movie1)
    movie2 = Movie('Inception', 2010, 'Christopher Nolan', 148)
    catalogue.add(movie2)
    print(catalogue)
except ValueError as e:
    print(f'Validation Error: {e}')
```
