---
id: 68b6d5244e6ce639e52fd1e7
title: Step 16
challengeType: 20
dashedName: step-16
---

# --description--

What if you want to represent a different type of media item, let's say a tv series? You could create another class and make it inherit from `Movie` to have access to all of its methods and attributes.

Create an empty class named `TVSeries` and make it inherit from `Movie`. Here's how to make a `Child` class inherit from a `Parent` class.

```py
class Parent:
    ...

class Child(Parent):
    ...
```

# --hints--

You should have a class named `TVSeries`.

```js
({
  test: () => runPython(`assert _Node(_code).has_class("TVSeries")`)
})
```

Your `TVSeries` class should inherit from `Movie`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("TVSeries").inherits_from("Movie")`)
})
```

# --seed--

## --seed-contents--

```py
class Movie:
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'
--fcc-editable-region--

--fcc-editable-region--
class MediaCatalogue:
    def __init__(self):
        self.items = []

    def add(self, media_item):
        self.items.append(media_item)

    def __str__(self):
        if not self.items:
            return 'Media Catalogue (empty)'

        result = f'Media Catalogue ({len(self.items)} items):\n\n'
        
        for i, movie in enumerate(self.items, 1):
            result += f'{i}. {movie}\n'
        return result

catalogue = MediaCatalogue()

try:
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)
    catalogue.add(movie1)
    movie2 = Movie('Inception', 2010, 'Christopher Nolan', 148)
    catalogue.add(movie2)
    print(catalogue)
except ValueError as e:
    print(f'Validation Error: {e}')
```
