---
id: 68b6cc518177b0a11c3fe3b1
title: Step 14
challengeType: 20
dashedName: step-14
---

# --description--

Before the `try` block, create an instance of `MediaCatalogue` and assign it to a variable named `catalogue`.

Then, use the `add` method to append `movie1` to the catalogue. Finally print `catalogue` to the console.

# --hints--

You should assign an instance of `MediaCatalogue` to a variable named `catalogue` before your `try` block.

```js
({
  test: () => runPython(`assert _Node(_code).has_stmt("catalogue = MediaCatalogue()")`)
})
```

You should have `catalogue.add(movie1)` in your `try` block.

```js
({
    test: () => runPython(`assert _Node(_code).find_trys()[0].find_body().has_stmt("catalogue.add(movie1)")`)
})
```

You should print `catalogue` at the end of your `try` block.

```js
({
    test: () => runPython(`assert _Node(_code).find_trys()[0].find_body().is_ordered("catalogue.add(movie1)", "print(catalogue)")`)
})
```

# --seed--

## --seed-contents--

```py
class Movie:
    def __init__(self, title, year, director, duration):
        if not title.strip():
            raise ValueError('Title cannot be empty')
        if year < 1895:
            raise ValueError('Year must be 1895 or later')
        if not director.strip():
            raise ValueError('Director cannot be empty')
        if duration <= 0:
            raise ValueError('Duration must be positive')
        self.title = title
        self.year = year
        self.director = director
        self.duration = duration

    def __str__(self):
        return f'{self.title} ({self.year}) - {self.duration} min, {self.director}'

class MediaCatalogue:
    def __init__(self):
        self.items = []

    def add(self, media_item):
        self.items.append(media_item)

    def __str__(self):
        if not self.items:
            return 'Media Catalogue (empty)'

        result = f'Media Catalogue ({len(self.items)} items):\n\n'
        
        for i, movie in enumerate(self.items, 1):
            result += f'{i}. {movie}\n'
        return result
--fcc-editable-region--


try:
    movie1 = Movie('The Matrix', 1999, 'The Wachowskis', 136)

--fcc-editable-region--
except ValueError as e:
    print(f'Validation Error: {e}')
```
