---
id: 6143b9e1f5035c6e5f2a8231
title: Step 19
challengeType: 0
dashedName: step-19
---

# --description--

Within your `ul` element, create six `li` elements. Add an `h4` element with a `class` set to `list-subtitle` and a `p` element to each of your `li` elements.

Then give the `h4` and `p` elements the following text content, in order, with each `h4` using what's on the left side of the colon, and each `p` using what's on the right:

- `V1 - 2014`: `We launched freeCodeCamp with a simple list of 15 resources, including Harvard's CS50 and Stanford's Database Class.`
- `V2 - 2015`: `We added interactive algorithm challenges.`
- `V3 - 2015`: `We added our own HTML+CSS challenges (before we'd been relying on General Assembly's Dash course for these).`
- `V4 - 2016`: `We expanded the curriculum to 3 certifications, including Front End, Back End, and Data Visualization. They each had 10 required projects, but only the Front End section had its own challenges. For the other certs, we were still using external resources like Node School.`
- `V5 - 2017`: `We added the back end and data visualization challenges.`
- `V6 - 2018`: `We launched 6 new certifications to replace our old ones. This was the biggest curriculum improvement to date.`

# --hints--

Your `ul` element should have six `li` elements.

```js
assert.lengthOf(document.querySelectorAll('.lists li'), 6);
```

Each of your new `li` elements should have an `h4` and `p` element.

```js
const lis = document.querySelectorAll('.lists li');
assert.isNotEmpty(lis);
lis.forEach(li => {
  assert.equal(li?.children?.[0]?.localName, 'h4');
  assert.equal(li?.children?.[1]?.localName, 'p');
});
```

Your first `h4` should have the text `V1 - 2014`.

```js
assert.equal(document.querySelectorAll('.lists li h4')?.[0]?.innerText, 'V1 - 2014');
```

Your first `p` should have the text `We launched freeCodeCamp with a simple list of 15 resources, including Harvard's CS50 and Stanford's Database Class.`

```js
assert.equal(document.querySelectorAll('.lists li p')?.[0]?.innerText, 'We launched freeCodeCamp with a simple list of 15 resources, including Harvard\'s CS50 and Stanford\'s Database Class.');
```

Your second `h4` should have the text `V2 - 2015`.

```js
assert.equal(document.querySelectorAll('.lists li h4')?.[1]?.innerText, 'V2 - 2015');
```

Your second `p` should have the text `We added interactive algorithm challenges.`

```js
assert.equal(document.querySelectorAll('.lists li p')?.[1]?.innerText, 'We added interactive algorithm challenges.');
```

Your third `h4` should have the text `V3 - 2015`.

```js
assert.equal(document.querySelectorAll('.lists li h4')?.[2]?.innerText, 'V3 - 2015');
```

Your third `p` should have the text `We added our own HTML+CSS challenges (before we'd been relying on General Assembly's Dash course for these).`

```js
assert.equal(document.querySelectorAll('.lists li p')?.[2]?.innerText, 'We added our own HTML+CSS challenges (before we\'d been relying on General Assembly\'s Dash course for these).');
```

Your fourth `h4` should have the text `V4 - 2016`.

```js
assert.equal(document.querySelectorAll('.lists li h4')?.[3]?.innerText, 'V4 - 2016');
```

Your fourth `p` should have the text `We expanded the curriculum to 3 certifications, including Front End, Back End, and Data Visualization. They each had 10 required projects, but only the Front End section had its own challenges. For the other certs, we were still using external resources like Node School.`

```js
assert.equal(document.querySelectorAll('.lists li p')?.[3]?.innerText, 'We expanded the curriculum to 3 certifications, including Front End, Back End, and Data Visualization. They each had 10 required projects, but only the Front End section had its own challenges. For the other certs, we were still using external resources like Node School.');
```

Your fifth `h4` should have the text `V5 - 2017`.

```js
assert.equal(document.querySelectorAll('.lists li h4')?.[4]?.innerText, 'V5 - 2017');
```

Your fifth `p` should have the text `We added the back end and data visualization challenges.`

```js
assert.equal(document.querySelectorAll('.lists li p')?.[4]?.innerText, 'We added the back end and data visualization challenges.');
```

Your sixth `h4` should have the text `V6 - 2018`.

```js
assert.equal(document.querySelectorAll('.lists li h4')?.[5]?.innerText, 'V6 - 2018');
```

Your sixth `p` should have the text `We launched 6 new certifications to replace our old ones. This was the biggest curriculum improvement to date.`

```js
assert.equal(document.querySelectorAll('.lists li p')?.[5]?.innerText, 'We launched 6 new certifications to replace our old ones. This was the biggest curriculum improvement to date.');
```

Your six `h4` elements should each have the class `list-subtitle`.

```js
const h4s = document.querySelectorAll('.lists li h4');
assert.isNotEmpty(h4s);
h4s.forEach(h4 => {
  assert.isTrue(h4?.classList?.contains('list-subtitle'));
});
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Magazine</title>
    <link
      href="https://fonts.googleapis.com/css?family=Anton%7CBaskervville%7CRaleway&display=swap"
      rel="stylesheet"
    />
    <link
      rel="stylesheet"
      href="https://use.fontawesome.com/releases/v5.8.2/css/all.css"
    />
    <link rel="stylesheet" href="styles.css" />
  </head>
  <body>
    <main>
      <section class="heading">
        <header class="hero">
          <img
            src="https://cdn.freecodecamp.org/platform/universal/fcc_meta_1920X1080-indigo.png"
            alt="freecodecamp logo"
            loading="lazy"
            class="hero-img"
            width="400"
          />
          <h1 class="hero-title">OUR NEW CURRICULUM</h1>
          <p class="hero-subtitle">
            Our efforts to restructure our curriculum with a more project-based
            focus
          </p>
        </header>
        <div class="author">
          <p class="author-name">
            By
            <a href="https://freecodecamp.org" target="_blank" rel="noreferrer"
              >freeCodeCamp</a
            >
          </p>
          <p class="publish-date">March 7, 2019</p>
        </div>
        <div class="social-icons">
          <a href="https://www.facebook.com/freecodecamp/">
            <i class="fab fa-facebook-f"></i>
          </a>
          <a href="https://twitter.com/freecodecamp/">
            <i class="fab fa-twitter"></i>
          </a>
          <a href="https://instagram.com/freecodecamp">
            <i class="fab fa-instagram"></i>
          </a>
          <a href="https://www.linkedin.com/school/free-code-camp/">
            <i class="fab fa-linkedin-in"></i>
          </a>
          <a href="https://www.youtube.com/freecodecamp">
            <i class="fab fa-youtube"></i>
          </a>
        </div>
      </section>
      <section class="text">
        <p class="first-paragraph">
          Soon the freeCodeCamp curriculum will be 100% project-driven learning. Instead of a series of coding challenges, you'll learn through building projects - step by step. Before we get into the details, let me emphasize: we are not changing the certifications. All 6 certifications will still have the same 5 required projects. We are only changing the optional coding challenges.
        </p>
        <p>
          After years - years - of pondering these two problems and how to solve them, I slipped, hit my head on the sink, and when I came to I had a revelation! A vision! A picture in my head! A picture of this! This is what makes time travel possible: the flux capacitor!
        </p>
        <p>
          It wasn't as dramatic as Doc's revelation in Back to the Future. It
          just occurred to me while I was going for a run. The revelation: the entire curriculum should be a series of projects. Instead of individual coding challenges, we'll just have projects, each with their own seamless series of tests. Each test gives you just enough information to figure out how to get it to pass. (And you can view hints if that isn't enough.)
        </p>
        <blockquote>
          <hr />
          <p class="quote">
            The entire curriculum should be a series of projects
          </p>
          <hr />
        </blockquote>
        <p>
          No more walls of explanatory text. No more walls of tests. Just one
          test at a time, as you build up a working project. Over the course of passing thousands of tests, you build up projects and your own understanding of coding fundamentals. There is no transition between lessons and projects, because the lessons themselves are baked into projects. And there's plenty of repetition to help you retain everything because - hey - building projects in real life has plenty of repetition.
        </p>
        <p>
          The main design challenge is taking what is currently paragraphs of explanation and instructions and packing them into a single test description text. Each project will involve dozens of tests like this. People will be coding the entire time, rather than switching back and forth from "reading mode" to "coding mode".
        </p>
        <p>
          Instead of a series of coding challenges, people will be in their code editor passing one test after another, quickly building up a project. People will get into a real flow state, similar to what they experience when they build the required projects at the end of each certification. They'll get that sense of forward progress right from the beginning. And freeCodeCamp will be a much smoother experience.
        </p>
      </section>
      <section class="text text-with-images">
--fcc-editable-region--
        <article class="brief-history">
          <h3 class="list-title">A Brief History</h3>
          <p>Of the Curriculum</p>
          <ul class="lists">
          
          </ul>
        </article>
--fcc-editable-region--
        <aside class="image-wrapper"></aside>
      </section>
    </main>
  </body>
</html>
```

```css

```
