---
id: 68225ea2f1aae301fa4df0f4
title: Step 9
challengeType: 1
dashedName: step-9
---

# --description--

While the array of results is working, the final desired result should be a string listing all of the books with a title and author.

This is where the `join()` method comes in. In earlier lessons, you learned that the `join()` method is used to return a new string of all of the array elements concatenated into a single string, with a specified separator between each element.

Here is a refresher:

```js
const developers = ["Naomi", "Tom", "Jessica"];

const teamList = developers.join("\n");
console.log(teamList); 
// Naomi
// Tom
// Jessica
```

The separator in this case is the `\n` which represents the newline character. 

Chain the `join()` method with a `\n` for the separator to the `map()`. Now you should see a string in the console instead of the array of results. 

# --hints--

Your `getBookInformation` function should return a string.

```js
assert.isString(getBookInformation(library));
```

Your `getBookInformation` function should return a single string representing the final result.

```js
const testLibrary = [
  {
    title: "Title A",
    author: "Author A",
    about: "About A",
    pages: 320,
  },
  {
    title: "Title B",
    author: "Author B",
    about: "About B",
    pages: 320,
  },
  {
    title: "Title C",
    author: "Author C",
    about: "About C",
    pages: 304,
  },
];

const expected = `Title A by Author A
Title B by Author B
Title C by Author C`;

assert.strictEqual(getBookInformation(testLibrary), expected);
```

# --seed--

## --seed-contents--

```js
const library = [
  {
    title: 'Your Next Five Moves: Master the Art of Business Strategy',
    author: 'Patrick Bet-David and Greg Dinkin',
    about: 'A book on how to plan ahead',
    pages: 320,
  },
  {
    title: 'Atomic Habits',
    author: 'James Clear',
    about: 'A practical book about discarding bad habits and building good ones',
    pages: 320,
  },
  {
    title: 'Choose Your Enemies Wisely: Business Planning for the Audacious Few',
    author: 'Patrick Bet-David',
    about:
      "A book that emphasizes the importance of identifying and understanding one's adversaries to succeed in the business world",
    pages: 304,
  },
  {
    title: 'The Embedded Entrepreneur',
    author: 'Arvid Kahl',
    about: 'A book focusing on how to build an audience-driven business',
    pages: 308,
  },
  {
    title: 'How to Be a Coffee Bean: 111 Life-Changing Ways to Create Positive Change',
    author: 'Jon Gordon',
    about: 'A book about effective ways to lead a coffee bean lifestyle',
    pages: 256,
  },
  {
    title: 'The Creative Mindset: Mastering the Six Skills That Empower Innovation',
    author: 'Jeff DeGraff and Staney DeGraff',
    about: 'A book on how to develop creativity and  innovation skills',
    pages: 168,
  },
  {
    title: 'Rich Dad Poor Dad',
    author: 'Robert Kiyosaki and Sharon Lechter',
    about: 'A book about financial literacy, financial independence, and building wealth. ',
    pages: 336,
  },
  {
    title: 'Zero to Sold',
    author: 'Arvid Kahl',
    about: 'A book on how to bootstrap a business',
    pages: 500,
  },
];

console.log("Books in the Library:\n");

--fcc-editable-region--
function getBookInformation(catalog) {
  return catalog.map(book => `${book.title} by ${book.author}`)
}
--fcc-editable-region--

console.log(getBookInformation(library));
```
