---
id: 67116d7584d0b469b14579c3
title: Step 14
challengeType: 1
dashedName: step-14
---

# --description--

In earlier lessons, you learned how to work with the `filter()` method which is used to return a new array of filtered results.

Here is an example:

```js
const developers = [
  { name: "Alice", city: "New York", age: 30 },
  { name: "Bob", city: "San Francisco", age: 25 },
  { name: "Charlie", city: "New York", age: 35 },
  { name: "Diana", city: "Chicago", age: 28 }
];

const newYorkCityDevelopers = developers.filter(dev => dev.city === "New York");

console.log(newYorkCityDevelopers);
/*
[
  { name: "Alice", city: "New York", age: 30 },
  { name: "Charlie", city: "New York", age: 35 }
]
*/
```

Create a `getBooksByAuthor` function with two parameters - an array with book objects and a string with the author.

The function must return an array that contains the books by a particular author.

# --hints--

You should create a `getBooksByAuthor` function.

```js
assert.isFunction(getBooksByAuthor);
```

Your `getBooksByAuthor` function should have two parameters.

```js
assert.lengthOf(getBooksByAuthor, 2);
```

Your `getBooksByAuthor` function should return an array.

```js
assert.isArray(getBooksByAuthor(library, ''));
```

Your `getBooksByAuthor` function should return the correct number of books for any of the authors.

```js
const arvidKahlBooks = getBooksByAuthor(library, 'Arvid Kahl');
const robertAndSharonBook = getBooksByAuthor(library, 'Robert Kiyosaki and Sharon Lechter');
const pbdAndGDBooks = getBooksByAuthor(library, 'Patrick Bet-David and Greg Dinkin');
const pbdBook = getBooksByAuthor(library, 'Patrick Bet-David');
const johnGordon = getBooksByAuthor(library, 'Jon Gordon');
const jamesClearBook = getBooksByAuthor(library, 'James Clear');
const JDAndSDBook = getBooksByAuthor(library, 'Jeff DeGraff and Staney DeGraff');

assert.lengthOf(arvidKahlBooks, 2);
assert.lengthOf(robertAndSharonBook, 1);
assert.lengthOf(pbdAndGDBooks, 1);
assert.lengthOf(pbdBook, 1);
assert.lengthOf(johnGordon, 1);
assert.lengthOf(jamesClearBook, 1);
assert.lengthOf(JDAndSDBook, 1);

const _differentLibrary = [
  {
    title: 'Title A',
    author: 'Author A',
    about: 'About A',
    pages: 320,
  },
  {
    title: 'Title B',
    author: 'Author B',
    about: 'About B',
    pages: 320,
  },
  {
    title: 'Title C',
    author: 'Author B',
    about: 'About C',
    pages: 304,
  },
];
assert.lengthOf(getBooksByAuthor(_differentLibrary, 'Author B'), 2);
assert.lengthOf(getBooksByAuthor(_differentLibrary, 'Author A'), 1);
```

# --seed--

## --seed-contents--

```js
const library = [
  {
    title: 'Your Next Five Moves: Master the Art of Business Strategy',
    author: 'Patrick Bet-David and Greg Dinkin',
    about: 'A book on how to plan ahead',
    pages: 320,
  },
  {
    title: 'Atomic Habits',
    author: 'James Clear',
    about: 'A practical book about discarding bad habits and building good ones',
    pages: 320,
  },
  {
    title: 'Choose Your Enemies Wisely: Business Planning for the Audacious Few',
    author: 'Patrick Bet-David',
    about:
      "A book that emphasizes the importance of identifying and understanding one's adversaries to succeed in the business world",
    pages: 304,
  },
  {
    title: 'The Embedded Entrepreneur',
    author: 'Arvid Kahl',
    about: 'A book focusing on how to build an audience-driven business',
    pages: 308,
  },
  {
    title: 'How to Be a Coffee Bean: 111 Life-Changing Ways to Create Positive Change',
    author: 'Jon Gordon',
    about: 'A book about effective ways to lead a coffee bean lifestyle',
    pages: 256,
  },
  {
    title: 'The Creative Mindset: Mastering the Six Skills That Empower Innovation',
    author: 'Jeff DeGraff and Staney DeGraff',
    about: 'A book on how to develop creativity and  innovation skills',
    pages: 168,
  },
  {
    title: 'Rich Dad Poor Dad',
    author: 'Robert Kiyosaki and Sharon Lechter',
    about: 'A book about financial literacy, financial independence, and building wealth. ',
    pages: 336,
  },
  {
    title: 'Zero to Sold',
    author: 'Arvid Kahl',
    about: 'A book on how to bootstrap a business',
    pages: 500,
  },
];

console.log("Books in the Library:\n");

function getBookInformation(catalog) {
  return catalog.map(book => `${book.title} by ${book.author}`).join("\n");
}

console.log(getBookInformation(library));

console.log("\nList of book summaries:\n");

function getBookSummaries(catalog) {
  return catalog.map((book) => book.about).join("\n");
}

console.log(getBookSummaries(library));

console.log("\nList of books by Arvid Kahl:\n");

--fcc-editable-region--

--fcc-editable-region--
```
