---
id: 67116d7584d0b469b14579c2
title: Step 11
challengeType: 1
dashedName: step-11
---

# --description--

To get a list of book summaries, you can use the `about` property of each book.

Create a `getBookSummaries` function with a single parameter, accepting an array with book objects.

The `getBookSummaries` function should return an array of strings representing the summary for each book.

# --hints--

You should create a `getBookSummaries` function.

```js
assert.isFunction(getBookSummaries);
```

Your `getBookSummaries` function should have one parameter.

```js
assert.lengthOf(getBookSummaries, 1);
```

Your `getBookSummaries` function should return an array.

```js
assert.isArray(getBookSummaries(library));
```

Your `getBookSummaries` function should return an array with the same length as the array passed to it.

```js
assert.lengthOf(getBookSummaries(library), 8);

const _differentLibrary = [
  {
    title: 'Title A',
    author: 'Author A',
    about: 'About A',
    pages: 320,
  },
  {
    title: 'Title B',
    author: 'Author B',
    about: 'About B',
    pages: 320,
  },
  {
    title: 'Title C',
    author: 'Author C',
    about: 'About C',
    pages: 304,
  },
];
assert.lengthOf(getBookSummaries(_differentLibrary), 3);
```

Your `getBookSummaries` function should return an array with the `about` property of each book from the array passed to it.

```js
const summaries = getBookSummaries(library);
library.forEach((book) => {
  assert.include(summaries, book.about);
});

const _differentLibrary = [
  {
    title: 'Title A',
    author: 'Author A',
    about: 'About A',
    pages: 320,
  },
  {
    title: 'Title B',
    author: 'Author B',
    about: 'About B',
    pages: 320,
  },
];
const differentSummaries = getBookSummaries(_differentLibrary);
_differentLibrary.forEach((book) => {
  assert.include(differentSummaries, book.about);
});
```

# --seed--

## --seed-contents--

```js
const library = [
  {
    title: 'Your Next Five Moves: Master the Art of Business Strategy',
    author: 'Patrick Bet-David and Greg Dinkin',
    about: 'A book on how to plan ahead',
    pages: 320,
  },
  {
    title: 'Atomic Habits',
    author: 'James Clear',
    about: 'A practical book about discarding bad habits and building good ones',
    pages: 320,
  },
  {
    title: 'Choose Your Enemies Wisely: Business Planning for the Audacious Few',
    author: 'Patrick Bet-David',
    about:
      "A book that emphasizes the importance of identifying and understanding one's adversaries to succeed in the business world",
    pages: 304,
  },
  {
    title: 'The Embedded Entrepreneur',
    author: 'Arvid Kahl',
    about: 'A book focusing on how to build an audience-driven business',
    pages: 308,
  },
  {
    title: 'How to Be a Coffee Bean: 111 Life-Changing Ways to Create Positive Change',
    author: 'Jon Gordon',
    about: 'A book about effective ways to lead a coffee bean lifestyle',
    pages: 256,
  },
  {
    title: 'The Creative Mindset: Mastering the Six Skills That Empower Innovation',
    author: 'Jeff DeGraff and Staney DeGraff',
    about: 'A book on how to develop creativity and  innovation skills',
    pages: 168,
  },
  {
    title: 'Rich Dad Poor Dad',
    author: 'Robert Kiyosaki and Sharon Lechter',
    about: 'A book about financial literacy, financial independence, and building wealth. ',
    pages: 336,
  },
  {
    title: 'Zero to Sold',
    author: 'Arvid Kahl',
    about: 'A book on how to bootstrap a business',
    pages: 500,
  },
];

console.log("Books in the Library:\n");

function getBookInformation(catalog) {
  return catalog.map(book => `${book.title} by ${book.author}`).join("\n");
}

console.log(getBookInformation(library));

console.log("\nList of book summaries:\n");

--fcc-editable-region--

--fcc-editable-region--
```
