---
id: 66a95d0eff8168747805f1f3
title: Step 19
challengeType: 0
dashedName: step-19
---

# --description--

When you want a user to select multiple options from a list, you can use checkboxes. 

Here is an example of how to work with checkboxes dealing with food options:

```html
<fieldset>
  <legend>Food Options</legend>
  <input type="checkbox" id="pizza" name="food" value="pizza">
  <label for="pizza">Pizza</label>
  <input type="checkbox" id="burger" name="food" value="burger">
  <label for="burger">Burger</label>
</fieldset>
```

The `value` attribute is used to specify the value that will be sent to the server when the form is submitted.

Below your `legend` element, add a checkbox `input` with the `id` and `value` attributes set to `"ads"`, and the `name` attribute set to `"choice"`.

Below your checkbox `input`, add a `label` element with the text `Social Media Ads`. The `for` attribute should be set to `"ads"`.

# --hints--

You should have a checkbox `input` below your `legend` element.

```js
assert.exists(document.querySelector("fieldset:nth-of-type(3) legend + input[type='checkbox']"));
```

Your checkbox `input` should have an `id` attribute set to `"ads"`.

```js
assert.strictEqual(document.querySelector("fieldset:nth-of-type(3) legend + input[type='checkbox']")?.id, "ads");
```

Your checkbox `input` should have a `name` attribute set to `"choice"`.

```js
assert.strictEqual(document.querySelector("fieldset:nth-of-type(3) legend + input[type='checkbox']")?.name, "choice");
```

Your checkbox `input` should have a `value` attribute set to `"ads"`.

```js
assert.strictEqual(document.querySelector("fieldset:nth-of-type(3) legend + input[type='checkbox']")?.value, "ads");
```

You should have a `label` element below your checkbox `input`.

```js
assert.exists(document.querySelector("fieldset:nth-of-type(3) input[type='checkbox'] + label"));
```

Your `label` element should have the text `Social Media Ads`.

```js
assert.strictEqual(document.querySelector("fieldset:nth-of-type(3) input[type='checkbox'] + label")?.textContent?.trim(), "Social Media Ads");
```

Your `label` element should have a `for` attribute set to `"ads"`.

```js
assert.strictEqual(document.querySelector("fieldset:nth-of-type(3) input[type='checkbox'] + label")?.getAttribute("for"), "ads");
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <title>Hotel Feedback Form</title>
  </head>
  <body>
    <header>
      <h1>Hotel Feedback Form</h1>
      <p>
        Thank you for staying with us. Please provide feedback on your recent
        stay.
      </p>
    </header>
    <main>
      <form method="POST" action="https://hotel-feedback.freecodecamp.org">
        <fieldset>
          <legend>Personal Information</legend>
          <label for="full-name">Name (required):</label>
          <input type="text" id="full-name" name="name" placeholder="e.g., John Doe" required size="20">

          <label for="email">Email address (required):</label>
          <input
            placeholder="example@email.com"
            required
            id="email"
            type="email"
            name="email"
            size="20"
          />
          <label for="age">Age (optional):</label>
          <input type="number" name="age" id="age" min="3" max="100" />
        </fieldset>

        <fieldset>
          <legend>Was this your first time at our hotel?</legend>
          <input id="yes-option" type="radio" name="hotel-stay" />
          <label for="yes-option">Yes</label>
          <input id="no-option" type="radio" name="hotel-stay" />
          <label for="no-option">No</label>
        </fieldset>

        --fcc-editable-region--
        <fieldset>
          <legend>
            Why did you choose to stay at our hotel? (Check all that apply)
          </legend>
          
        </fieldset>
        --fcc-editable-region--
      </form>
    </main>
  </body>
</html>
```
