---
id: 67f90574263ebf363f9edd1d
title: Step 15
challengeType: 0
dashedName: step-15
---

# --description--

If `query` is not empty, you want to get fruits that match the user input from the API, but only after users stop typing for a short period to avoid making the fetch call too frequently.

To start, after the `if` statement, call `setTimeout` with an empty arrow function and a delay value of `700` as arguments, and store it in a variable called `timeoutId`. This allows you to cancel the timeout later when the effect cleans up.

# --hints--

You should call `setTimeout` and store the return value in a variable called `timeoutId`.

```js
assert.match(code, /(const|let|var)\s+timeoutId\s*=\s*setTimeout\s*\(/s);
```

`setTimeout` should have an empty callback function and a delay value of `700`.

```js
assert.match(code, /(const|let|var)\s+timeoutId\s*=\s*setTimeout\s*\(\s*\(\s*\)\s*=>\s*\{\s*\}\s*,\s*700\s*\)/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8" />
  <title>Fruits Search</title>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.min.js"></script>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.min.js"></script>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.5/babel.min.js"></script>
  <script 
    data-plugins="transform-modules-umd"
    type="text/babel"
    src="index.jsx"
  ></script>
  <link rel="stylesheet" href="styles.css" />
</head>
<body>
  <div id="root"></div>
  <script
    data-plugins="transform-modules-umd"
    type="text/babel"
    data-presets="react"
    data-type="module"
  >
    import { FruitsSearch } from './index.jsx';
    ReactDOM.createRoot(document.getElementById('root')).render(<FruitsSearch />);
  </script>
</body>
</html>
```

```css
body {
  font-family: Arial, sans-serif;
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  background-color: #f4f4f4;
}

#search-container {
  text-align: center;
  background: white;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}

#search-input {
  padding: 10px;
  width: 80%;
  border: 1px solid #ccc;
  border-radius: 5px;
  margin-bottom: 10px;
}

#results {
  text-align: left;
  max-height: 150px;
  overflow-y: auto;
}
.result-item {
  padding: 5px;
  border-bottom: 1px solid #ddd;
}
```

```jsx
const { useState, useEffect } = React;

export function FruitsSearch() {
  const [query, setQuery] = useState('');
  const [results, setResults] = useState([]);

  function handleSubmit(e) {
    e.preventDefault();
  }

--fcc-editable-region--
  useEffect(() => {
    if (query.trim() === '') {
      setResults([]);
      return;
    }
    
  }, [query]);
--fcc-editable-region--

  return (
    <div id="search-container">
      <form onSubmit={handleSubmit}>
        <label htmlFor="search-input">Search for fruits:</label>
        <input
          id="search-input"
          type="search"
          value={query}
          onChange={(e) => setQuery(e.target.value)}
        />
      </form>
      <div id="results">
        {results.length > 0 ? (
          results.map(item => (
            <p key={item} className="result-item">{item}</p>
          ))
        ) : (
          <p>No results found</p>
        )}
      </div>
    </div>
  );
}
```
