---
id: 67f90485c192d92ba3ba7e34
title: Step 14
challengeType: 0
dashedName: step-14
---

# --description--

Inside the `useEffect` callback, add an `if` condition to check if `query.trim() === ''`. This checks if `query` is an empty string or contains only spaces. If so, call `setResults([])` and return early.

# --hints--

You should check if `query.trim() === ''`.

```js
const script = [...document.querySelectorAll("script")].find((s) => s.dataset.src ===  "index.jsx").innerText;
const exports = {};
const a = eval(script);
const fruitsSearchString = exports.FruitsSearch.toString();
assert.match(fruitsSearchString, /if\s*\(\s*query\.trim\(\)\s*===\s*['"]{2}\s*\)/);
```

If `query.trim() === ''` is true, call `setResults()` with an empty array, then use the `return` keyword after that.

```js
const script = [...document.querySelectorAll("script")].find((s) => s.dataset.src ===  "index.jsx").innerText;
const exports = {};
const a = eval(script);
const fruitsSearchString = exports.FruitsSearch.toString();
assert.match(fruitsSearchString, /{\s*setResults\(\s*\[\s*\]\s*\)\s*;?\s*return\s*;?\s*}/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8" />
  <title>Fruits Search</title>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.min.js"></script>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.min.js"></script>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.5/babel.min.js"></script>
  <script 
    data-plugins="transform-modules-umd"
    type="text/babel"
    src="index.jsx"
  ></script>
  <link rel="stylesheet" href="styles.css" />
</head>
<body>
  <div id="root"></div>
  <script
    data-plugins="transform-modules-umd"
    type="text/babel"
    data-presets="react"
    data-type="module"
  >
    import { FruitsSearch } from './index.jsx';
    ReactDOM.createRoot(document.getElementById('root')).render(<FruitsSearch />);
  </script>
</body>
</html>
```

```css
body {
  font-family: Arial, sans-serif;
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  background-color: #f4f4f4;
}

#search-container {
  text-align: center;
  background: white;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}

#search-input {
  padding: 10px;
  width: 80%;
  border: 1px solid #ccc;
  border-radius: 5px;
  margin-bottom: 10px;
}

#results {
  text-align: left;
  max-height: 150px;
  overflow-y: auto;
}
.result-item {
  padding: 5px;
  border-bottom: 1px solid #ddd;
}
```

```jsx
const { useState, useEffect } = React;

export function FruitsSearch() {
  const [query, setQuery] = useState('');
  const [results, setResults] = useState([]);

  function handleSubmit(e) {
    e.preventDefault();
  }

  --fcc-editable-region--
  useEffect(() => {
    
  }, [query]);
  --fcc-editable-region--

  return (
    <div id="search-container">
      <form onSubmit={handleSubmit}>
        <label htmlFor="search-input">Search for fruits:</label>
        <input
          id="search-input"
          type="search"
          value={query}
          onChange={(e) => setQuery(e.target.value)}
        />
      </form>
      <div id="results">
        {results.length > 0 ? (
          results.map(item => (
            <p key={item} className="result-item">{item}</p>
          ))
        ) : (
          <p>No results found</p>
        )}
      </div>
    </div>
  );
}
```
