---
id: 67f8ef57b9974052e5ef6b30
title: Step 12
challengeType: 0
dashedName: step-12
---

# --description--

Inside the `#results` element, use a ternary operator to check if the length of `results` array is greater than zero. If it is, map over the items and display each one in a `p` element with a class of `result-item`. Be sure to include a `key` attribute with each paragraph as well.

If `results` it's empty, render a `p` element with the message `No results found`.

# --hints--

Your `#results` container should contain a list of matching fruits based on the query. Each result should be a `p` element with the class of `result-item` and should show the name of the fruit.

```js
  {
    const mockResults = ["Item 1", "Item 2"];
    React.useState = (arg) => {
      if (Array.isArray(arg)) return [mockResults, () => {}]; 
      return [null, () => {}];
    };
    const script = [...document.querySelectorAll("script")].find((s) => s.dataset.src === "index.jsx").innerText;
    const exports = {};
    const _a = eval(script);
    const div = await __helpers.prepTestComponent(exports.FruitsSearch);
    const items = div.querySelectorAll("p.result-item");

    assert.equal(items.length, mockResults.length);
    assert.equal(items[0].textContent, "Item 1");
    assert.equal(items[1].textContent, "Item 2");

    assert.isTrue(items[0].classList.contains("result-item"));
    assert.isTrue(items[1].classList.contains("result-item"));
  }
```

Your `#results` element should contain a `p` element with the text `No results found` when the `results` array is empty.

```js
  {
    React.useState = (arg) => {
      if (Array.isArray(arg)) return [[], () => {}];
      return [null, () => {}];
    };
    const script = [...document.querySelectorAll("script")].find((s) => s.dataset.src === "index.jsx").innerText;
    const exports = {};
    const _a = eval(script);
    const div = await __helpers.prepTestComponent(exports.FruitsSearch);
    const noResultsEl = div.querySelector("#results p");
    assert.exists(noResultsEl);
    assert.equal(noResultsEl.textContent, "No results found");
  }
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8" />
  <title>Fruits Search</title>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.min.js"></script>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.min.js"></script>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.5/babel.min.js"></script>
  <script 
    data-plugins="transform-modules-umd"
    type="text/babel"
    src="index.jsx"
  ></script>
  <link rel="stylesheet" href="styles.css" />
</head>
<body>
  <div id="root"></div>
  <script
    data-plugins="transform-modules-umd"
    type="text/babel"
    data-presets="react"
    data-type="module"
  >
    import { FruitsSearch } from './index.jsx';
    ReactDOM.createRoot(document.getElementById('root')).render(<FruitsSearch />);
  </script>
</body>
</html>
```

```css
body {
  font-family: Arial, sans-serif;
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  background-color: #f4f4f4;
}

#search-container {
  text-align: center;
  background: white;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}

#search-input {
  padding: 10px;
  width: 80%;
  border: 1px solid #ccc;
  border-radius: 5px;
  margin-bottom: 10px;
}

#results {
  text-align: left;
  max-height: 150px;
  overflow-y: auto;
}
.result-item {
  padding: 5px;
  border-bottom: 1px solid #ddd;
}
```

```jsx
const { useState, useEffect } = React;

export function FruitsSearch() {
  const [query, setQuery] = useState('');
  const [results, setResults] = useState([]);

  function handleSubmit(e) {
    e.preventDefault();
  }

  return (
    <div id="search-container">
      <form onSubmit={handleSubmit}>
        <label htmlFor="search-input">Search for fruits:</label>
        <input
          id="search-input"
          type="search"
          value={query}
          onChange={(e) => setQuery(e.target.value)}
        />
      </form>
      --fcc-editable-region--
      <div id="results">

      </div>
      --fcc-editable-region--
    </div>
  );
}
```
