---
id: 67f8ec758a740e34432222db
title: Step 8
challengeType: 0
dashedName: step-8
---

# --description--

Add an `onChange` attribute to the input to capture what the user types. Set it to an arrow function that takes `e` as an argument. Inside the function, update the `query` state by passing `e.target.value` to the setter function, which holds the current value of the input. Here's an example:

```js
<input
  onChange={(e) => setExample(e.target.value)}
/>
```

# --hints--

You should ensure that the `onChange` handler is defined.

```js
const searchInput = document.getElementById("search-input");
assert.exists(searchInput);

const reactKey = Object.keys(searchInput).find(key => key.startsWith("__reactProps"));
const reactProps = searchInput[reactKey];

assert.exists(reactProps);
assert.isFunction(reactProps.onChange);
```

Your `onChange` handler should have an `e` parameter.

```js
const searchInput = document.getElementById("search-input");
assert.exists(searchInput);

const reactKey = Object.keys(searchInput).find(key => key.startsWith("__reactProps"));
const reactProps = searchInput[reactKey];

assert.match(reactProps.onChange.toString(), /onChange\s*\(\s*e\s*\)/);
```

Your `onChange` handler should call `setQuery()` with `e.target.value`.


```js
const searchInput = document.getElementById("search-input");
assert.exists(searchInput);

const reactKey = Object.keys(searchInput).find(key => key.startsWith("__reactProps"));
const reactProps = searchInput[reactKey];

assert.match(reactProps.onChange.toString(), /setQuery\s*\(\s*e\.target\.value\s*\)/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8" />
  <title>Fruits Search</title>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.min.js"></script>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.min.js"></script>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.5/babel.min.js"></script>
  <script 
    data-plugins="transform-modules-umd"
    type="text/babel"
    src="index.jsx"
  ></script>
  <link rel="stylesheet" href="styles.css" />
</head>
<body>
  <div id="root"></div>
  <script
    data-plugins="transform-modules-umd"
    type="text/babel"
    data-presets="react"
    data-type="module"
  >
    import { FruitsSearch } from './index.jsx';
    ReactDOM.createRoot(document.getElementById('root')).render(<FruitsSearch />);
  </script>
</body>
</html>
```

```css
body {
  font-family: Arial, sans-serif;
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  background-color: #f4f4f4;
}

#search-container {
  text-align: center;
  background: white;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}

#search-input {
  padding: 10px;
  width: 80%;
  border: 1px solid #ccc;
  border-radius: 5px;
  margin-bottom: 10px;
}

#results {
  text-align: left;
  max-height: 150px;
  overflow-y: auto;
}
.result-item {
  padding: 5px;
  border-bottom: 1px solid #ddd;
}
```

```jsx
const { useState, useEffect } = React;

export function FruitsSearch() {
  const [query, setQuery] = useState('');
  const [results, setResults] = useState([]);

  return (
    <div id="search-container">
      <form>
        <label htmlFor="search-input">Search for fruits:</label>
        --fcc-editable-region--
        <input
          id="search-input"
          type="search"
          value={query}
          
        />
        --fcc-editable-region--
      </form>
    </div>
  );
}
```
