---
id: 641daabed8d0584b1150c953
title: Step 22
challengeType: 0
dashedName: step-22
---

# --description--

Some of the author bios are much longer than others. To give the cards a uniform look, you can extract the first 50 characters of each one and replace the rest with an ellipsis `"..."`. Otherwise, you can show the entire bio.

Within the paragraph element, replace `bio` with a ternary operator. For the condition, check if the length of `bio` is greater than 50. If it is, use the `.slice()` method to extract the first 50 characters of `bio` and add an ellipsis at the end. Otherwise, show the full `bio`.

# --before-all--

```js
window.fetch = () => Promise.resolve({json: () => Promise.resolve([{ author: 'Whoever', image: 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==', url: "http://not-a-real-url.nowhere/", bio: 'words go here' }])});
```

# --hints--

You should create a `p` element.

```js
assert.match(code, /<p\s*/)
```

Your `p` element should have the class `bio`

```js
assert.match(code, /<p\s*class=("|')bio\1>/);
```

You should check if the length of the `bio` text is greater than `50`. 

```js
assert.match(code, /<p\s*class=("|')bio\1>\s*\$\{\s*bio\.length\s*>\s*50/)
```

If the `bio` text is greater than `50` characters, you should extract the first 50 characters with `slice()` and replace the rest with `"..."`. Don't forget that indexes are zero-based.

```js
assert.match(code, /<p\s*class\s*=\s*("|')bio\1\s*>\s*\$\{\s*bio\.length\s*>\s*50\s*\?\s*(?:bio\.slice\(\s*0\s*,\s*50\s*\)\s*\+\s*("|')\.\.\.\2|`\$\{\s*bio\.slice\(\s*0\s*,\s*50\s*\)\s*\}\.\.\.`)\s*:/);
```

If the `bio` text is less than 50 characters, use the `bio` text directly.

```js
assert.match(code, /<p\s*class\s*=\s*("|')bio\1\s*>\s*\$\{\s*bio\.length\s*>\s*50\s*\?\s*(?:bio\.slice\(\s*0\s*,\s*50\s*\)\s*\+\s*("|')\.\.\.\2|`\$\{\s*bio\.slice\(\s*0\s*,\s*50\s*\)\s*\}\.\.\.`)\s*:\s*bio\s*\}\s*<\/p>/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>freeCodeCamp News Author Page</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <h1 class="title">freeCodeCamp News Author Page</h1>

    <main>
      <div id="author-container"></div>
      <button class="btn" id="load-more-btn">Load More Authors</button>
    </main>

    <script src="./script.js"></script>
  </body>
</html>
```

```css
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

:root {
  --main-bg-color: #1b1b32;
  --light-grey: #f5f6f7;
  --dark-purple: #5a01a7;
  --golden-yellow: #feac32;
}

body {
  background-color: var(--main-bg-color);
  text-align: center;
}

.title {
  color: var(--light-grey);
  margin: 20px 0;
}

#author-container {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
}

.user-card {
  border-radius: 15px;
  width: 300px;
  height: 350px;
  background-color: var(--light-grey);
  margin: 20px;
}

.user-img {
  width: 150px;
  height: 150px;
  object-fit: cover;
}

.purple-divider {
  background-color: var(--dark-purple);
  width: 100%;
  height: 15px;
}

.author-name {
  margin: 10px;
}

.bio {
  margin: 20px;
}

.error-msg {
  color: var(--light-grey);
}

.btn {
  cursor: pointer;
  width: 200px;
  margin: 10px;
  color: var(--main-bg-color);
  font-size: 14px;
  background-color: var(--golden-yellow);
  background-image: linear-gradient(#fecc4c, #ffac33);
  border-color: var(--golden-yellow);
  border-width: 3px;
}
```

```js
const authorContainer = document.getElementById('author-container');
const loadMoreBtn = document.getElementById('load-more-btn');

let startingIndex = 0;
let endingIndex = 8;
let authorDataArr = [];

fetch('https://cdn.freecodecamp.org/curriculum/news-author-page/authors.json')
  .then((res) => res.json())
  .then((data) => {
    authorDataArr = data;
    displayAuthors(authorDataArr.slice(startingIndex, endingIndex));  
  })
  .catch((err) => {
    console.error(`There was an error: ${err}`);
  });

const fetchMoreAuthors = () => {
  startingIndex += 8;
  endingIndex += 8;

  displayAuthors(authorDataArr.slice(startingIndex, endingIndex));
  if (authorDataArr.length <= endingIndex) {
    loadMoreBtn.disabled = true;
    loadMoreBtn.textContent = 'No more data to load';
  }
};

const displayAuthors = (authors) => {
  authors.forEach(({ author, image, url, bio }, index) => {
    authorContainer.innerHTML += `
    <div id="${index}" class="user-card">
      <h2 class="author-name">${author}</h2>
      <img class="user-img" src="${image}" alt="${author} avatar" />
      <div class="purple-divider"></div>
      --fcc-editable-region--
      <p class="bio">${bio}</p>
      --fcc-editable-region--
      <a class="author-link" href="${url}" target="_blank">${author}'s author page</a>
    </div>
  `;
  });
};

loadMoreBtn.addEventListener('click', fetchMoreAuthors);
```
