---
id: 641da7bfbc7f0f477438ad8a
title: Step 11
challengeType: 0
dashedName: step-11
---

# --description--

Now it's time to call the `displayAuthors` function. But again, you don't want to populate the page with all the authors at once. Instead, you can extract a portion of the authors with the `startingIndex` and `endingIndex` variables. The best method to do this is the `.slice()` array method.

First, remove the console log statement showing `authorDataArr`. Then, call the `displayAuthors` function with the `authorDataArr` array and `.slice()`. Use the `startingIndex` variable for the starting point and the `endingIndex` variable for the ending point.

# --before-all--

```js
window.fetch = () => Promise.resolve({json: () => Promise.resolve([{ author: 'Whoever', image: 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==', url: "http://not-a-real-url.nowhere/", bio: 'words go here' }])});
```

# --hints--

You should assign `data` to the `authorDataArr` variable

```js
assert.match(code, /authorDataArr\s*=\s*data\s*;?/)
```

You should remove the console log statement showing `authorDataArr`

```js
assert.notMatch(code, /console\.log\(\s*("|'|`)Author\s+Data\s+Array:\s*\1\s*,\s*authorDataArr\s*\)\s*;?/)
```

You should call your `displayAuthors` function.

```js
assert.match(code, /displayAuthors\(/)
```

You should call your `displayAuthors` function and pass in an argument of `authorDataArr.slice()`.

```js
assert.match(code, /displayAuthors\(\s*authorDataArr\.slice\(/)
```

The first parameter of your `slice()` method should be `startingIndex`.

```js
assert.match(code, /displayAuthors\(\s*authorDataArr\.slice\(\s*startingIndex/)
```

The second parameter of your `slice()` method should be `endingIndex`.

```js
assert.match(code, /displayAuthors\(\s*authorDataArr\.slice\(\s*startingIndex\s*,\s*endingIndex\s*\)\s*\)\s*;?/)
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>freeCodeCamp News Author Page</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <h1 class="title">freeCodeCamp News Author Page</h1>

    <main>
      <div id="author-container"></div>
      <button class="btn" id="load-more-btn">Load More Authors</button>
    </main>

    <script src="./script.js"></script>
  </body>
</html>
```

```css
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

:root {
  --main-bg-color: #1b1b32;
  --light-grey: #f5f6f7;
  --dark-purple: #5a01a7;
  --golden-yellow: #feac32;
}

body {
  background-color: var(--main-bg-color);
  text-align: center;
}

.title {
  color: var(--light-grey);
  margin: 20px 0;
}

#author-container {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
}

.user-card {
  border-radius: 15px;
  width: 300px;
  height: 350px;
  background-color: var(--light-grey);
  margin: 20px;
}

.user-img {
  width: 150px;
  height: 150px;
  object-fit: cover;
}

.purple-divider {
  background-color: var(--dark-purple);
  width: 100%;
  height: 15px;
}

.author-name {
  margin: 10px;
}

.bio {
  margin: 20px;
}

.error-msg {
  color: var(--light-grey);
}

.btn {
  cursor: pointer;
  width: 200px;
  margin: 10px;
  color: var(--main-bg-color);
  font-size: 14px;
  background-color: var(--golden-yellow);
  background-image: linear-gradient(#fecc4c, #ffac33);
  border-color: var(--golden-yellow);
  border-width: 3px;
}
```

```js
const authorContainer = document.getElementById('author-container');
const loadMoreBtn = document.getElementById('load-more-btn');

let startingIndex = 0;
let endingIndex = 8;
let authorDataArr = [];

fetch('https://cdn.freecodecamp.org/curriculum/news-author-page/authors.json')
  .then((res) => res.json())
  .then((data) => {
    --fcc-editable-region--
    authorDataArr = data;
    console.log("Author Data Array:", authorDataArr);

    --fcc-editable-region-- 
  })
  .catch((err) => {
    console.error(`There was an error: ${err}`);
  });

const displayAuthors = (authors) => {
  authors.forEach(({ author, image, url, bio }, index) => {
    authorContainer.innerHTML += `
    <div id="${index}" class="user-card">
      <h2 class="author-name">${author}</h2>
    </div>
  `;
  });
};
```
