---
id: 641da5462576784453146ec2
title: Step 7
challengeType: 0
dashedName: step-7
---

# --description--

Now that you have the data you want, you can use it to populate the UI. 

But the data you are fetching will have a total of 26 authors. Instead of displaying all 26 authors at once, you should display 8 authors at a time.

Start by using the `let` keyword to create two variables named `startingIndex` and `endingIndex`, and assign them the numbers `0` and `8`, respectively. You will need to use `let` here because you will be reassigning these values later on.

Then, create an `authorDataArr` variable and assign it an empty array. 

Declare and initialize each variable on a separate line.

# --before-all--

```js
window.fetch = () => Promise.resolve({json: () => Promise.resolve([{ author: 'Whoever', image: 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==', url: "http://not-a-real-url.nowhere/", bio: 'words go here' }])});
```

# --hints--

You should use `let` to declare a variable named `startingIndex`.

```js
assert.match(code, /let\s+startingIndex/);
```

Your `startingIndex` variable should be a number.

```js
assert.isNumber(startingIndex);
```

Your `startingIndex` variable should be set to `0`.

```js
assert.strictEqual(startingIndex, 0);
```

You should use `let` to declare a variable named `endingIndex`.

```js
assert.match(code, /let\s+endingIndex/);
```

Your `endingIndex` variable should be a number.
  
  ```js
assert.isNumber(endingIndex);
```

You should set your `endingIndex` variable to `8`.

```js
assert.strictEqual(endingIndex, 8)
```

You should have a variable named `authorDataArr`.

```js
assert.isDefined(authorDataArr);
```

Your `authorDataArr` variable should be an empty array.

```js
assert.isArray(authorDataArr);
assert.isEmpty(authorDataArr);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>freeCodeCamp News Author Page</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <h1 class="title">freeCodeCamp News Author Page</h1>

    <main>
      <div id="author-container"></div>
      <button class="btn" id="load-more-btn">Load More Authors</button>
    </main>

    <script src="./script.js"></script>
  </body>
</html>
```

```css
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

:root {
  --main-bg-color: #1b1b32;
  --light-grey: #f5f6f7;
  --dark-purple: #5a01a7;
  --golden-yellow: #feac32;
}

body {
  background-color: var(--main-bg-color);
  text-align: center;
}

.title {
  color: var(--light-grey);
  margin: 20px 0;
}

#author-container {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
}

.user-card {
  border-radius: 15px;
  width: 300px;
  height: 350px;
  background-color: var(--light-grey);
  margin: 20px;
}

.user-img {
  width: 150px;
  height: 150px;
  object-fit: cover;
}

.purple-divider {
  background-color: var(--dark-purple);
  width: 100%;
  height: 15px;
}

.author-name {
  margin: 10px;
}

.bio {
  margin: 20px;
}

.error-msg {
  color: var(--light-grey);
}

.btn {
  cursor: pointer;
  width: 200px;
  margin: 10px;
  color: var(--main-bg-color);
  font-size: 14px;
  background-color: var(--golden-yellow);
  background-image: linear-gradient(#fecc4c, #ffac33);
  border-color: var(--golden-yellow);
  border-width: 3px;
}
```

```js
const authorContainer = document.getElementById('author-container');
const loadMoreBtn = document.getElementById('load-more-btn');

--fcc-editable-region--

--fcc-editable-region--

fetch('https://cdn.freecodecamp.org/curriculum/news-author-page/authors.json')
  .then((res) => res.json())
  .then((data) => {
    console.log(data);   
  })
  .catch((err) => {
    console.error(`There was an error: ${err}`);
  });
```
