---
id: 68a9fa1976616e330813a96c
title: Step 14
challengeType: 0
dashedName: step-14
---

# --description--

Now make some space, remove all the button variables and the `eventListener` you have created for each.

# --hints--

The `happyBtn` variable should not exist.

```js
try {
  happyBtn;
  assert.fail('happyBtn variable should not exist');
} catch (e) {
  assert.equal(e.name, 'ReferenceError', 'happyBtn variable should not exist');
}
```

The `confusedBtn` variable should not exist.

```js
try {
  confusedBtn;
  assert.fail('confusedBtn variable should not exist');
} catch (e) {
  assert.equal(e.name, 'ReferenceError', 'confusedBtn variable should not exist');
}
```

The `sadBtn` variable should not exist.

```js
try {
  sadBtn;
  assert.fail('sadBtn variable should not exist');
} catch (e) {
  assert.equal(e.name, 'ReferenceError', 'sadBtn variable should not exist');
}
```

The `lovingBtn` variable should not exist.

```js
try {
  lovingBtn;
  assert.fail('lovingBtn variable should not exist');
} catch (e) {
  assert.equal(e.name, 'ReferenceError', 'lovingBtn variable should not exist');
}
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Emoji Reactor</title>
  <link rel="stylesheet" href="./styles.css" />
</head>
<body>
  <main>

    <h1 class="title">How are you feeling today?</h1>

    <p class="description">
      Click on the buttons below to rate your emotions.
    </p>
    <div class="btn-container">
      <button id="happy-btn" class="emoji-btn" aria-label="Happy face emoji">
        <span role="img" aria-hidden="true">😊</span>
        <span class="count">0/10</span>
      </button>
      <button
        id="confused-btn"
        class="emoji-btn"
        aria-label="Confused face emoji"
      >
        <span role="img" aria-hidden="true">😕</span>
        <span class="count">0/10</span>
      </button>
      <button id="sad-btn" class="emoji-btn" aria-label="Angry face emoji">
        <span role="img" aria-hidden="true">😠</span>
        <span class="count">0/10</span>
      </button>
      <button
        id="loving-btn"
        class="emoji-btn"
        aria-label="Loving face emoji"
      >
        <span role="img" aria-hidden="true">😍</span>
        <span class="count">0/10</span>
      </button>
    </div>
  </main>
  <script src="./script.js"></script>
</body>
</html>
```

```css
*,
*::before,
*::after {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
}

:root {
  --light-grey: #efefef;
  --white: #ffffff;
  --very-dark-blue: #0a0a23;
  --light-purple: #a78bfa;
  --very-light-purple: #c4b5fd;
  --purple: #8b5cf6;
}

body {
  background-color: var(--very-dark-blue);
  color: var(--light-grey);
  font-family: sans-serif;
}

main {
  text-align: center;
  padding: 10px;
}

.btn-container,
button {
  display: flex;
  justify-content: space-evenly;
  align-items: center;
}

.btn-container {
  flex-direction: column;
}

.emoji-btn {
  width: 70%;
  cursor: pointer;
  color: var(--white);
  background-color: var(--light-purple);
  background-image: linear-gradient(
    to bottom,
    var(--very-light-purple),
    var(--light-purple)
  );
  border: 3px solid var(--purple);
  border-radius: 8px;
  padding: 10px;
  font-size: 1.5rem;
  margin: 10px 0;
  transition: background-color 0.3s ease, transform 0.2s ease;
}

@media (min-width: 768px) {
  .emoji-btn {
    width: 30%;
  }
}

.emoji-btn:hover {
  background-color: var(--purple);
  background-image: none;
}

.title {
  margin-top: 15px;
  font-size: 2rem;
}

.description {
  font-size: 1.4rem;
  margin: 20px 0;
}
```

```js
function updateCount(btn) {
  const countEl = btn.querySelector(".count");
  let currCount = +countEl.textContent.split("/")[0];
  
  if (currCount === 10) return;
  
  currCount++;
  
  countEl.textContent = `${currCount}/10`;
}


const btns = document.querySelectorAll(".emoji-btn");

--fcc-editable-region--
const happyBtn = document.querySelector("#happy-btn");
const confusedBtn = document.querySelector("#confused-btn");
const sadBtn = document.querySelector("#sad-btn");
const lovingBtn = document.querySelector("#loving-btn");

happyBtn.addEventListener("click", () => updateCount(happyBtn));
confusedBtn.addEventListener("click", () => updateCount(confusedBtn));
sadBtn.addEventListener("click", () => updateCount(sadBtn));
lovingBtn.addEventListener("click", () => updateCount(lovingBtn));
--fcc-editable-region--
```
