---
id: 68a9f8378ddba1261a268cce
title: Step 11
challengeType: 0
dashedName: step-11
---

# --description--

You can make the code more reusable.

Create a function called `updateCount` that takes a button element as a parameter.

This function should contain all the logic for updating a button's count: finding the count element, parsing the current count, checking if it's at the maximum, incrementing, and updating the display.

Then update your event listener callback to call `updateCount(happyBtn)` instead of having the logic inline.

# --hints--

You should create a function named `updateCount`.

```js
assert.isFunction(updateCount);
```

The `updateCount` function should take a button parameter.

```js
assert.equal(updateCount.length, 1);
```

The `updateCount` function should work correctly with any button element.

```js
const testBtn = document.createElement("button");
testBtn.innerHTML = '<span class="count">3/10</span>';
updateCount(testBtn);
assert.equal(testBtn.querySelector(".count").textContent, "4/10");
```

Your event listener should call `updateCount` with the button as an argument.

```js
const spy = __helpers.spyOn(window, "updateCount");
document.querySelector("#happy-btn").click();
assert.equal(spy.calls.length, 1);
assert.equal(spy.calls[0][0], document.querySelector("#happy-btn"));
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Emoji Reactor</title>
  <link rel="stylesheet" href="./styles.css" />
</head>
<body>
  <main>

    <h1 class="title">How are you feeling today?</h1>

    <p class="description">
      Click on the buttons below to rate your emotions.
    </p>
    <div class="btn-container">
      <button id="happy-btn" class="emoji-btn" aria-label="Happy face emoji">
        <span role="img" aria-hidden="true">😊</span>
        <span class="count">0/10</span>
      </button>
    </div>
  </main>
  <script src="./script.js"></script>
</body>
</html>
```

```css
*,
*::before,
*::after {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
}

:root {
  --light-grey: #efefef;
  --white: #ffffff;
  --very-dark-blue: #0a0a23;
  --light-purple: #a78bfa;
  --very-light-purple: #c4b5fd;
  --purple: #8b5cf6;
}

body {
  background-color: var(--very-dark-blue);
  color: var(--light-grey);
  font-family: sans-serif;
}

main {
  text-align: center;
  padding: 10px;
}

.btn-container,
button {
  display: flex;
  justify-content: space-evenly;
  align-items: center;
}

.btn-container {
  flex-direction: column;
}

.emoji-btn {
  width: 70%;
  cursor: pointer;
  color: var(--white);
  background-color: var(--light-purple);
  background-image: linear-gradient(
    to bottom,
    var(--very-light-purple),
    var(--light-purple)
  );
  border: 3px solid var(--purple);
  border-radius: 8px;
  padding: 10px;
  font-size: 1.5rem;
  margin: 10px 0;
  transition: background-color 0.3s ease, transform 0.2s ease;
}

@media (min-width: 768px) {
  .emoji-btn {
    width: 30%;
  }
}

.emoji-btn:hover {
  background-color: var(--purple);
  background-image: none;
}

.title {
  margin-top: 15px;
  font-size: 2rem;
}

.description {
  font-size: 1.4rem;
  margin: 20px 0;
}
```

```js
--fcc-editable-region--
const happyBtn = document.querySelector("#happy-btn");

happyBtn.addEventListener("click", () => {
  const countEl = happyBtn.querySelector(".count");
  let currCount = +countEl.textContent.split("/")[0];
  
  if (currCount === 10) return;
  
  currCount++;
  
  countEl.textContent = `${currCount}/10`;
})


--fcc-editable-region--
```
