---
id: 689b15aacce1ae176ec768dc
title: Step 9
challengeType: 0
dashedName: step-9
---

# --description--

Now, you need to get the first number in the `0/10` text, in a way that will work even for `5/10` or `10/10`.

Parse the text content of the `.count` element to extract the current number.

Convert the count from a string to a number.

Log the current count in this format: `console.log("Current count:", currCount)`.

Hint: remember you can use the `split` method to divide a string into an array of substrings.

# --hints--

You should log the current count as a number.

```js
const spy = __helpers.spyOn(console, "log");
document.querySelector(`#happy-btn`).click();

assert.sameDeepOrderedMembers(spy.calls[0], ["Current count:", 0]);
```

You should log the current count as a number in a way that works for the various possible values.

```js
const spy = __helpers.spyOn(console, "log");
const testString = "5/10";
document.querySelector("#happy-btn .count").textContent = testString;
document.querySelector(`#happy-btn`).click();

assert.sameDeepOrderedMembers(spy.calls, [["Current count:", 5]]);

const testString2 = "10/10";
document.querySelector("#happy-btn .count").textContent = testString2;
document.querySelector(`#happy-btn`).click();

assert.sameDeepOrderedMembers(spy.calls[1], ["Current count:", 10]);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Emoji Reactor</title>
  <link rel="stylesheet" href="./styles.css" />
</head>
<body>
  <main>

    <h1 class="title">How are you feeling today?</h1>

    <p class="description">
      Click on the buttons below to rate your emotions.
    </p>
    <div class="btn-container">
      <button id="happy-btn" class="emoji-btn" aria-label="Happy face emoji">
        <span role="img" aria-hidden="true">😊</span>
        <span class="count">0/10</span>
      </button>
    </div>
  </main>
  <script src="./script.js"></script>
</body>
</html>
```

```css
*,
*::before,
*::after {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
}

:root {
  --light-grey: #efefef;
  --white: #ffffff;
  --very-dark-blue: #0a0a23;
  --light-purple: #a78bfa;
  --very-light-purple: #c4b5fd;
  --purple: #8b5cf6;
}

body {
  background-color: var(--very-dark-blue);
  color: var(--light-grey);
  font-family: sans-serif;
}

main {
  text-align: center;
  padding: 10px;
}

.btn-container,
button {
  display: flex;
  justify-content: space-evenly;
  align-items: center;
}

.btn-container {
  flex-direction: column;
}

.emoji-btn {
  width: 70%;
  cursor: pointer;
  color: var(--white);
  background-color: var(--light-purple);
  background-image: linear-gradient(
    to bottom,
    var(--very-light-purple),
    var(--light-purple)
  );
  border: 3px solid var(--purple);
  border-radius: 8px;
  padding: 10px;
  font-size: 1.5rem;
  margin: 10px 0;
  transition: background-color 0.3s ease, transform 0.2s ease;
}

@media (min-width: 768px) {
  .emoji-btn {
    width: 30%;
  }
}

.emoji-btn:hover {
  background-color: var(--purple);
  background-image: none;
}

.title {
  margin-top: 15px;
  font-size: 2rem;
}

.description {
  font-size: 1.4rem;
  margin: 20px 0;
}
```

```js
--fcc-editable-region--
const happyBtn = document.querySelector("#happy-btn");

happyBtn.addEventListener("click", () => {
  const countEl = happyBtn.querySelector(".count");
  console.log(countEl.textContent);
})


--fcc-editable-region--
```
