---
id: 688798fccea91f522d1f245e
title: Step 33
challengeType: 20
dashedName: step-33
---

# --description--

When the inbox is not empty, you'll try to access the email at the given index and display it. 

Remember in the `list_emails` method, you displayed email numbers starting from 1, but list indices in Python start from 0. So, you'll need to convert the 1-based index to a 0-based index by subtracting 1.

Within the `read_email` method, subtract 1 from the `index` parameter and store it in a variable called `actual_index`. 


# --hints--

You should subtract 1 from the `index` parameter and store it in a variable called `actual_index`.

```js
({
    test: () => 
    {
        assert(runPython(`_Node(_code).find_class("Inbox").find_function("read_email").find_body().find_variable("actual_index").is_equivalent("actual_index = index - 1")`))
    }
})
```

# --seed--

## --seed-contents--

```py
class Email:
    def __init__(self, sender, receiver, subject, body):
        self.sender = sender
        self.receiver = receiver
        self.subject = subject
        self.body = body
        self.read = False

    def mark_as_read(self):
        self.read = True

    def display_full_email(self):
        self.mark_as_read()
        print('\n--- Email ---')
        print(f'From: {self.sender.name}')
        print(f'To: {self.receiver.name}')
        print(f'Subject: {self.subject}')
        print(f'Body: {self.body}')
        print('------------\n')

    def __str__(self):
        status = 'Read' if self.read else 'Unread'
        return f"[{status}] From: {self.sender.name} | Subject: {self.subject}"
class User:
    def __init__(self, name):
        self.name = name
        self.inbox = Inbox()

    def send_email(self, receiver, subject, body):
        email = Email(sender=self, receiver=receiver, subject=subject, body=body)
        receiver.inbox.receive_email(email)

class Inbox:
    def __init__(self):
        self.emails = []

    def receive_email(self, email):
        self.emails.append(email)

    def list_emails(self):
        if not self.emails:
            print('Your inbox is empty.\n')
            return
        print('\nYour Emails:')
        for i, email in enumerate(self.emails, start=1):
            print(f'{i}. {email}')

--fcc-editable-region--
    def read_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        
--fcc-editable-region--

```
