---
id: 685d53b5e4f5784562a12d1b
title: Step 45
challengeType: 20
dashedName: step-45
---

# --description--

Users should get confirmation when they successfully send an email. Let's improve the user experience by adding feedback to the `send_email` method.

In the `send_email` method of the `User` class, add a `print` statement after the email is sent that shows confirmation. The message should be `Email sent from [sender_name] to [receiver_name]!\n`, where `[sender_name]` is replaced by the sender's name and `[receiver_name]` is replaced by the receiver's name.

# --hints--

You should add a print statement in the `send_email` method that confirms the email was sent.

```js
({
    test: () => {
        assert(runPython(`_Node(_code).find_class("User").find_function("send_email").has_call("print(f'Email sent from {self.name} to {receiver.name}!\\\\n')")`));
    }
})
```

# --seed--

## --seed-contents--

```py
import datetime

class Email:
    def __init__(self, sender, receiver, subject, body):
        self.sender = sender
        self.receiver = receiver
        self.subject = subject
        self.body = body
        self.timestamp = datetime.datetime.now()
        self.read = False

    def mark_as_read(self):
        self.read = True

    def display_full_email(self):
        self.mark_as_read()
        print('\n--- Email ---')
        print(f'From: {self.sender.name}')
        print(f'To: {self.receiver.name}')
        print(f'Subject: {self.subject}')
        print(f"Received: {self.timestamp.strftime('%Y-%m-%d %H:%M')}")
        print(f'Body: {self.body}')
        print('------------\n')

    def __str__(self):
        status = 'Read' if self.read else 'Unread'
        return f"[{status}] From: {self.sender.name} | Subject: {self.subject} | Time: {self.timestamp.strftime('%Y-%m-%d %H:%M')}"

class User:
    def __init__(self, name):
        self.name = name
        self.inbox = Inbox()

--fcc-editable-region--
    def send_email(self, receiver, subject, body):
        email = Email(sender=self, receiver=receiver, subject=subject, body=body)
        receiver.inbox.receive_email(email)
        
--fcc-editable-region--

class Inbox:
    def __init__(self):
        self.emails = []

    def receive_email(self, email):
        self.emails.append(email)

    def list_emails(self):
        if not self.emails:
            print('Your inbox is empty.\n')
            return
        print('\nYour Emails:')
        for i, email in enumerate(self.emails, start=1):
            print(f'{i}. {email}')

    def read_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        actual_index = index - 1
        if actual_index < 0 or actual_index >= len(self.emails):
            print('Invalid email number.\n')
            return
        self.emails[actual_index].display_full_email()

    def delete_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        actual_index = index - 1
        if actual_index < 0 or actual_index >= len(self.emails):
            print('Invalid email number.\n')
            return
        del self.emails[actual_index]
        print('Email deleted.\n')
```

