---
id: 685d2fd1f309b9191f257c55
title: Step 40
challengeType: 20
dashedName: step-40
---

# --description--

Before integrating timestamps into our email system, let's practice working with datetime formatting. The `datetime.datetime.now()` function gives us the current date and time, and we can use the `strftime()` method to format it in different ways.

Here's how `strftime()` works with format codes:

```python
now = datetime.datetime.now()
print(now.strftime("%Y-%m-%d"))  # Output: 2024-03-15 (year-month-day with - separator)
```

The format codes like `%Y` (year), `%m` (month), `%d` (day) tell `strftime()` what to include, and you can add separators like `-` between them.

At the bottom of your code, create a variable called `current_time` and assign it `datetime.datetime.now()`. Then use `strftime()` to print the time in hours:minutes:seconds format using `:` as the separator. 

Use these format codes: `%H` for hours (24-hour format), `%M` for minutes, and `%S` for seconds.

# --hints--

You should create a variable called `current_time` and assign it `datetime.datetime.now()`.

```js
({
    test: () => {
        assert(runPython(`_Node(_code).has_stmt("current_time = datetime.datetime.now()")`));
    }
})
```

You should use `strftime()` to print the time in `%H:%M:%S` format.

```js
({
    test: () => {
        assert(runPython(`_Node(_code).has_call("print(current_time.strftime('%H:%M:%S'))")`));
    }
})
```

# --seed--

## --seed-contents--

```py
import datetime

class Email:
    def __init__(self, sender, receiver, subject, body):
        self.sender = sender
        self.receiver = receiver
        self.subject = subject
        self.body = body
        self.read = False

    def mark_as_read(self):
        self.read = True

    def display_full_email(self):
        self.mark_as_read()
        print('\n--- Email ---')
        print(f'From: {self.sender.name}')
        print(f'To: {self.receiver.name}')
        print(f'Subject: {self.subject}')
        print(f'Body: {self.body}')
        print('------------\n')

    def __str__(self):
        status = 'Read' if self.read else 'Unread'
        return f"[{status}] From: {self.sender.name} | Subject: {self.subject}"
class User:
    def __init__(self, name):
        self.name = name
        self.inbox = Inbox()

    def send_email(self, receiver, subject, body):
        email = Email(sender=self, receiver=receiver, subject=subject, body=body)
        receiver.inbox.receive_email(email)

class Inbox:
    def __init__(self):
        self.emails = []

    def receive_email(self, email):
        self.emails.append(email)

    def list_emails(self):
        if not self.emails:
            print('Your inbox is empty.\n')
            return
        print('\nYour Emails:')
        for i, email in enumerate(self.emails, start=1):
            print(f'{i}. {email}')

    def read_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        actual_index = index - 1
        if actual_index < 0 or actual_index >= len(self.emails):
            print('Invalid email number.\n')
            return
        self.emails[actual_index].display_full_email()

    def delete_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        actual_index = index - 1
        if actual_index < 0 or actual_index >= len(self.emails):
            print('Invalid email number.\n')
            return
        del self.emails[actual_index]
        print('Email deleted.\n')

--fcc-editable-region--

--fcc-editable-region--
```
